/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class PubSubManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(PubSubManager.class.getName());
    private static final Map<XMPPConnection, Map<BareJid, PubSubManager>> INSTANCES = new WeakHashMap<XMPPConnection, Map<BareJid, PubSubManager>>();
    private final BareJid pubSubService;
    private final Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public static PubSubManager getInstance(XMPPConnection connection) {
        DomainBareJid pubSubService = null;
        if (connection.isAuthenticated()) {
            try {
                pubSubService = PubSubManager.getPubSubService(connection);
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Could not determine PubSub service", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "Interupted while trying to determine PubSub service", e);
            }
        }
        if (pubSubService == null) {
            try {
                pubSubService = JidCreate.domainBareFrom((String)("pubsub." + connection.getXMPPServiceDomain()));
            }
            catch (XmppStringprepException e) {
                throw new RuntimeException(e);
            }
        }
        return PubSubManager.getInstance(connection, (BareJid)pubSubService);
    }

    public static synchronized PubSubManager getInstance(XMPPConnection connection, BareJid pubSubService) {
        PubSubManager pubSubManager;
        Map<BareJid, PubSubManager> managers = INSTANCES.get(connection);
        if (managers == null) {
            managers = new HashMap<BareJid, PubSubManager>();
            INSTANCES.put(connection, managers);
        }
        if ((pubSubManager = managers.get(pubSubService)) == null) {
            pubSubManager = new PubSubManager(connection, pubSubService);
            managers.put(pubSubService, pubSubManager);
        }
        return pubSubManager;
    }

    PubSubManager(XMPPConnection connection, BareJid toAddress) {
        super(connection);
        this.pubSubService = toAddress;
    }

    public LeafNode createNode() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.CREATE), null);
        NodeExtension elem = (NodeExtension)reply.getExtension("create", PubSubNamespace.BASIC.getXmlns());
        LeafNode newNode = new LeafNode(this, elem.getNode());
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public LeafNode createNode(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return (LeafNode)this.createNode(nodeId, null);
    }

    public Node createNode(String nodeId, Form config) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = PubSub.createPubsubPacket((Jid)this.pubSubService, IQ.Type.set, new NodeExtension(PubSubElementType.CREATE, nodeId), null);
        boolean isLeafNode = true;
        if (config != null) {
            request.addExtension(new FormNode(FormNodeType.CONFIGURE, config));
            FormField nodeTypeField = config.getField(ConfigureNodeFields.node_type.getFieldName());
            if (nodeTypeField != null) {
                isLeafNode = nodeTypeField.getValues().get(0).equals(NodeType.leaf.toString());
            }
        }
        this.sendPubsubPacket(request);
        Node newNode = isLeafNode ? new LeafNode(this, nodeId) : new CollectionNode(this, nodeId);
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public <T extends Node> T getNode(String id) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Node node = this.nodeMap.get(id);
        if (node == null) {
            DiscoverInfo info = new DiscoverInfo();
            info.setTo((Jid)this.pubSubService);
            info.setNode(id);
            DiscoverInfo infoReply = (DiscoverInfo)this.connection().createStanzaCollectorAndSend((IQ)info).nextResultOrThrow();
            if (infoReply.hasIdentity("pubsub", "leaf")) {
                node = new LeafNode(this, id);
            } else if (infoReply.hasIdentity("pubsub", "collection")) {
                node = new CollectionNode(this, id);
            } else {
                throw new AssertionError((Object)("PubSub service '" + this.pubSubService + "' returned disco info result for node '" + id + "', but it did not contain an Identity of type 'leaf' or 'collection' (and category 'pubsub'), which is not allowed according to XEP-60 5.3."));
            }
            this.nodeMap.put(id, node);
        }
        Node res = node;
        return (T)res;
    }

    public DiscoverItems discoverNodes(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items = new DiscoverItems();
        if (nodeId != null) {
            items.setNode(nodeId);
        }
        items.setTo((Jid)this.pubSubService);
        DiscoverItems nodeItems = (DiscoverItems)this.connection().createStanzaCollectorAndSend((IQ)items).nextResultOrThrow();
        return nodeItems;
    }

    public List<Subscription> getSubscriptions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.SUBSCRIPTIONS), null);
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtension(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subElem.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.AFFILIATIONS), null);
        AffiliationsExtension listElem = (AffiliationsExtension)reply.getExtension(PubSubElementType.AFFILIATIONS);
        return listElem.getAffiliations();
    }

    public void deleteNode(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.DELETE, nodeId), PubSubElementType.DELETE.getNamespace());
        this.nodeMap.remove(nodeId);
    }

    public ConfigureForm getDefaultConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket((Stanza)reply, PubSubElementType.DEFAULT);
    }

    public BareJid getServiceJid() {
        return this.pubSubService;
    }

    public DiscoverInfo getSupportedFeatures() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager mgr = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return mgr.discoverInfo((Jid)this.pubSubService);
    }

    public boolean canCreateNodesAndPublishItems() throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException {
        LeafNode leafNode = null;
        try {
            leafNode = this.createNode();
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getXMPPError().getCondition() == XMPPError.Condition.forbidden) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (leafNode != null) {
                this.deleteNode(leafNode.getId());
            }
        }
        return true;
    }

    private PubSub sendPubsubPacket(IQ.Type type, ExtensionElement ext, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.sendPubsubPacket((Jid)this.pubSubService, type, Collections.singletonList(ext), ns);
    }

    XMPPConnection getConnection() {
        return this.connection();
    }

    PubSub sendPubsubPacket(Jid to, IQ.Type type, List<ExtensionElement> extList, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = new PubSub(to, type, ns);
        for (ExtensionElement pe : extList) {
            pubSub.addExtension(pe);
        }
        return this.sendPubsubPacket(pubSub);
    }

    PubSub sendPubsubPacket(PubSub packet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IQ resultIQ = (IQ)this.connection().createStanzaCollectorAndSend((IQ)packet).nextResultOrThrow();
        if (resultIQ instanceof EmptyResultIQ) {
            return null;
        }
        return (PubSub)resultIQ;
    }

    public static DomainBareJid getPubSubService(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(connection).findService("http://jabber.org/protocol/pubsub", true, "pubsub", "service");
    }
}

