/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dnssec;

import de.measite.minidns.DNSCache;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.DNSName;
import de.measite.minidns.Question;
import de.measite.minidns.Record;
import de.measite.minidns.dnssec.DNSSECMessage;
import de.measite.minidns.dnssec.DNSSECValidationFailedException;
import de.measite.minidns.dnssec.UnverifiedReason;
import de.measite.minidns.dnssec.Verifier;
import de.measite.minidns.iterative.ReliableDNSClient;
import de.measite.minidns.record.DLV;
import de.measite.minidns.record.DNSKEY;
import de.measite.minidns.record.DS;
import de.measite.minidns.record.Data;
import de.measite.minidns.record.RRSIG;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DNSSECClient
extends ReliableDNSClient {
    private static final BigInteger rootEntryKey = new BigInteger("03010001a80020a95566ba42e886bb804cda84e47ef56dbd7aec612615552cec906d2116d0ef207028c51554144dfeafe7c7cb8f005dd18234133ac0710a81182ce1fd14ad2283bc83435f9df2f6313251931a176df0da51e54f42e604860dfb359580250f559cc543c4ffd51cbe3de8cfd06719237f9fc47ee729da06835fa452e825e9a18ebc2ecbcf563474652c33cf56a9033bcdf5d973121797ec8089041b6e03a1b72d0a735b984e03687309332324f27c2dba85e9db15e83a0143382e974b0621c18e625ecec907577d9e7bade95241a81ebbe8a901d4d3276e40b114c0a2e6fc38d19c2e6aab02644b2813f575fc21601e0dee49cd9ee96a43103e524d62873d", 16);
    private static final DNSName DEFAULT_DLV = DNSName.from((String)"dlv.isc.org");
    private Verifier verifier = new Verifier();
    private final Map<DNSName, byte[]> knownSeps = new ConcurrentHashMap<DNSName, byte[]>();
    private boolean stripSignatureRecords = true;
    private DNSName dlv;

    public DNSSECClient() {
        this((DNSCache)DEFAULT_CACHE);
    }

    public DNSSECClient(DNSCache cache) {
        super(cache);
        this.addSecureEntryPoint(DNSName.EMPTY, rootEntryKey.toByteArray());
    }

    public DNSMessage query(Question q) throws IOException {
        return this.queryDnssec(q);
    }

    public DNSSECMessage queryDnssec(CharSequence name, Record.TYPE type) throws IOException {
        Question q = new Question(name, type, Record.CLASS.IN);
        DNSMessage dnsMessage = super.query(q);
        DNSSECMessage dnssecMessage = this.performVerification(q, dnsMessage);
        return dnssecMessage;
    }

    public DNSSECMessage queryDnssec(Question q) throws IOException {
        DNSMessage dnsMessage = super.query(q);
        DNSSECMessage dnssecMessage = this.performVerification(q, dnsMessage);
        return dnssecMessage;
    }

    private DNSSECMessage performVerification(Question q, DNSMessage dnsMessage) throws IOException {
        if (dnsMessage == null) {
            return null;
        }
        if (dnsMessage.authenticData) {
            dnsMessage = dnsMessage.asBuilder().setAuthenticData(false).build();
        }
        Set<UnverifiedReason> unverifiedReasons = this.verify(dnsMessage);
        return this.createDnssecMessage(dnsMessage, unverifiedReasons);
    }

    private DNSSECMessage createDnssecMessage(DNSMessage dnsMessage, Set<UnverifiedReason> result) {
        List answers = dnsMessage.answerSection;
        List nameserverRecords = dnsMessage.authoritySection;
        List additionalResourceRecords = dnsMessage.additionalSection;
        HashSet<Record<RRSIG>> signatures = new HashSet<Record<RRSIG>>();
        Record.filter(signatures, RRSIG.class, (Collection)answers);
        Record.filter(signatures, RRSIG.class, (Collection)nameserverRecords);
        Record.filter(signatures, RRSIG.class, (Collection)additionalResourceRecords);
        DNSMessage.Builder messageBuilder = dnsMessage.asBuilder();
        if (this.stripSignatureRecords) {
            messageBuilder.setAnswers(DNSSECClient.stripSignatureRecords(answers));
            messageBuilder.setNameserverRecords(DNSSECClient.stripSignatureRecords(nameserverRecords));
            messageBuilder.setAdditionalResourceRecords(DNSSECClient.stripSignatureRecords(additionalResourceRecords));
        }
        return new DNSSECMessage(messageBuilder, signatures, result);
    }

    private static List<Record<? extends Data>> stripSignatureRecords(List<Record<? extends Data>> records) {
        if (records.isEmpty()) {
            return records;
        }
        ArrayList<Record<? extends Data>> recordList = new ArrayList<Record<? extends Data>>(records.size());
        for (Record<? extends Data> record : records) {
            if (record.type == Record.TYPE.RRSIG) continue;
            recordList.add(record);
        }
        return recordList;
    }

    protected boolean isResponseCacheable(Question q, DNSMessage dnsMessage) {
        return super.isResponseCacheable(q, dnsMessage);
    }

    private Set<UnverifiedReason> verify(DNSMessage dnsMessage) throws IOException {
        if (!dnsMessage.answerSection.isEmpty()) {
            return this.verifyAnswer(dnsMessage);
        }
        return this.verifyNsec(dnsMessage);
    }

    private Set<UnverifiedReason> verifyAnswer(DNSMessage dnsMessage) throws IOException {
        Question q = (Question)dnsMessage.questions.get(0);
        List answers = dnsMessage.answerSection;
        List toBeVerified = dnsMessage.copyAnswers();
        VerifySignaturesResult verifiedSignatures = this.verifySignatures(q, answers, toBeVerified);
        Set<UnverifiedReason> result = verifiedSignatures.reasons;
        if (!result.isEmpty()) {
            return result;
        }
        boolean sepSignatureValid = false;
        HashSet<UnverifiedReason> sepReasons = new HashSet<UnverifiedReason>();
        Iterator iterator = toBeVerified.iterator();
        while (iterator.hasNext()) {
            Record record = ((Record)iterator.next()).ifPossibleAs(DNSKEY.class);
            if (record == null) continue;
            Set<UnverifiedReason> reasons = this.verifySecureEntryPoint(q, (Record<DNSKEY>)record);
            if (reasons.isEmpty()) {
                sepSignatureValid = true;
            } else {
                sepReasons.addAll(reasons);
            }
            if (!verifiedSignatures.sepSignaturePresent) {
                LOGGER.finer("SEP key is not self-signed.");
            }
            iterator.remove();
        }
        if (verifiedSignatures.sepSignaturePresent && !sepSignatureValid) {
            result.addAll(sepReasons);
        }
        if (verifiedSignatures.sepSignatureRequired && !verifiedSignatures.sepSignaturePresent) {
            result.add(new UnverifiedReason.NoSecureEntryPointReason(q.name.ace));
        }
        if (!toBeVerified.isEmpty()) {
            if (toBeVerified.size() != answers.size()) {
                throw new DNSSECValidationFailedException(q, "Only some records are signed!");
            }
            result.add(new UnverifiedReason.NoSignaturesReason(q));
        }
        return result;
    }

    private Set<UnverifiedReason> verifyNsec(DNSMessage dnsMessage) throws IOException {
        HashSet<UnverifiedReason> result = new HashSet<UnverifiedReason>();
        Question q = (Question)dnsMessage.questions.get(0);
        boolean validNsec = false;
        boolean nsecPresent = false;
        DNSName zone = null;
        List nameserverRecords = dnsMessage.authoritySection;
        for (Record nameserverRecord : nameserverRecords) {
            if (nameserverRecord.type != Record.TYPE.SOA) continue;
            zone = nameserverRecord.name;
        }
        if (zone == null) {
            throw new DNSSECValidationFailedException(q, "NSECs must always match to a SOA");
        }
        block5: for (Record record : nameserverRecords) {
            UnverifiedReason reason;
            switch (record.type) {
                case NSEC: {
                    nsecPresent = true;
                    reason = this.verifier.verifyNsec((Record<? extends Data>)record, q);
                    break;
                }
                case NSEC3: {
                    nsecPresent = true;
                    reason = this.verifier.verifyNsec3(zone, (Record<? extends Data>)record, q);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (reason != null) {
                result.add(reason);
                continue;
            }
            validNsec = true;
        }
        if (nsecPresent && !validNsec) {
            throw new DNSSECValidationFailedException(q, "Invalid NSEC!");
        }
        List toBeVerified = dnsMessage.copyAuthority();
        VerifySignaturesResult verifiedSignatures = this.verifySignatures(q, nameserverRecords, toBeVerified);
        if (validNsec && verifiedSignatures.reasons.isEmpty()) {
            result.clear();
        } else {
            result.addAll(verifiedSignatures.reasons);
        }
        if (!toBeVerified.isEmpty() && toBeVerified.size() != nameserverRecords.size()) {
            throw new DNSSECValidationFailedException(q, "Only some nameserver records are signed!");
        }
        return result;
    }

    private VerifySignaturesResult verifySignatures(Question q, Collection<Record<? extends Data>> reference, List<Record<? extends Data>> toBeVerified) throws IOException {
        Date now = new Date();
        LinkedList<RRSIG> outdatedRrSigs = new LinkedList<RRSIG>();
        VerifySignaturesResult result = new VerifySignaturesResult();
        ArrayList<Record> rrsigs = new ArrayList<Record>(toBeVerified.size());
        for (Record<? extends Data> recordToBeVerified : toBeVerified) {
            Record record = recordToBeVerified.ifPossibleAs(RRSIG.class);
            if (record == null) continue;
            RRSIG rrsig = (RRSIG)record.payloadData;
            if (rrsig.signatureExpiration.compareTo(now) < 0 || rrsig.signatureInception.compareTo(now) > 0) {
                outdatedRrSigs.add(rrsig);
                continue;
            }
            rrsigs.add(record);
        }
        if (rrsigs.isEmpty()) {
            if (!outdatedRrSigs.isEmpty()) {
                result.reasons.add(new UnverifiedReason.NoActiveSignaturesReason(q, outdatedRrSigs));
            } else {
                result.reasons.add(new UnverifiedReason.NoSignaturesReason(q));
            }
            return result;
        }
        for (Record sigRecord : rrsigs) {
            RRSIG rrsig = (RRSIG)sigRecord.payloadData;
            ArrayList<Record<? extends Data>> records = new ArrayList<Record<? extends Data>>(reference.size());
            for (Record<? extends Data> record : reference) {
                if (record.type != rrsig.typeCovered || !record.name.equals((Object)sigRecord.name)) continue;
                records.add(record);
            }
            Set<UnverifiedReason> reasons = this.verifySignedRecords(q, rrsig, records);
            result.reasons.addAll(reasons);
            if (q.name.equals((Object)rrsig.signerName) && rrsig.typeCovered == Record.TYPE.DNSKEY) {
                Iterator iterator = records.iterator();
                while (iterator.hasNext()) {
                    Record dnsKeyRecord = ((Record)iterator.next()).ifPossibleAs(DNSKEY.class);
                    DNSKEY dnskey = (DNSKEY)dnsKeyRecord.payloadData;
                    iterator.remove();
                    if (dnskey.getKeyTag() != rrsig.keyTag) continue;
                    result.sepSignaturePresent = true;
                }
                result.sepSignatureRequired = true;
            }
            if (!DNSSECClient.isParentOrSelf(sigRecord.name.ace, rrsig.signerName.ace)) {
                LOGGER.finer("Records at " + sigRecord.name + " are cross-signed with a key from " + rrsig.signerName);
            } else {
                toBeVerified.removeAll(records);
            }
            toBeVerified.remove(sigRecord);
        }
        return result;
    }

    private static boolean isParentOrSelf(String child, String parent) {
        if (child.equals(parent)) {
            return true;
        }
        if (parent.isEmpty()) {
            return true;
        }
        String[] childSplit = child.split("\\.");
        String[] parentSplit = parent.split("\\.");
        if (parentSplit.length > childSplit.length) {
            return false;
        }
        for (int i = 1; i <= parentSplit.length; ++i) {
            if (parentSplit[parentSplit.length - i].equals(childSplit[childSplit.length - i])) continue;
            return false;
        }
        return true;
    }

    private Set<UnverifiedReason> verifySignedRecords(Question q, RRSIG rrsig, List<Record<? extends Data>> records) throws IOException {
        HashSet<UnverifiedReason> result = new HashSet<UnverifiedReason>();
        DNSKEY dnskey = null;
        if (rrsig.typeCovered == Record.TYPE.DNSKEY) {
            for (Record<? extends Data> record : records) {
                Record dnsKeyRecord = record.ifPossibleAs(DNSKEY.class);
                if (dnsKeyRecord == null || ((DNSKEY)dnsKeyRecord.payloadData).getKeyTag() != rrsig.keyTag) continue;
                dnskey = (DNSKEY)dnsKeyRecord.payloadData;
                break;
            }
        } else {
            if (q.type == Record.TYPE.DS && rrsig.signerName.equals((Object)q.name)) {
                result.add(new UnverifiedReason.NoTrustAnchorReason(q.name.ace));
                return result;
            }
            DNSSECMessage dnskeyRes = this.queryDnssec((CharSequence)rrsig.signerName, Record.TYPE.DNSKEY);
            if (dnskeyRes == null) {
                throw new DNSSECValidationFailedException(q, "There is no DNSKEY " + rrsig.signerName + ", but it is used");
            }
            result.addAll(dnskeyRes.getUnverifiedReasons());
            for (Record record : dnskeyRes.answerSection) {
                Record dnsKeyRecord = record.ifPossibleAs(DNSKEY.class);
                if (dnsKeyRecord == null || ((DNSKEY)dnsKeyRecord.payloadData).getKeyTag() != rrsig.keyTag) continue;
                dnskey = (DNSKEY)dnsKeyRecord.payloadData;
            }
        }
        if (dnskey == null) {
            throw new DNSSECValidationFailedException(q, records.size() + " " + rrsig.typeCovered + " record(s) are signed using an unknown key.");
        }
        UnverifiedReason unverifiedReason = this.verifier.verify(records, rrsig, dnskey);
        if (unverifiedReason != null) {
            result.add(unverifiedReason);
        }
        return result;
    }

    private Set<UnverifiedReason> verifySecureEntryPoint(Question q, Record<DNSKEY> sepRecord) throws IOException {
        DNSSECMessage dlvResp;
        DNSKEY dnskey = (DNSKEY)sepRecord.payloadData;
        HashSet<UnverifiedReason> unverifiedReasons = new HashSet<UnverifiedReason>();
        Set<Object> activeReasons = new HashSet();
        if (this.knownSeps.containsKey(sepRecord.name)) {
            if (dnskey.keyEquals(this.knownSeps.get(sepRecord.name))) {
                return unverifiedReasons;
            }
            unverifiedReasons.add(new UnverifiedReason.ConflictsWithSep(sepRecord));
            return unverifiedReasons;
        }
        if (sepRecord.name.isRootLabel()) {
            unverifiedReasons.add(new UnverifiedReason.NoRootSecureEntryPointReason());
            return unverifiedReasons;
        }
        DS delegation = null;
        DNSSECMessage dsResp = this.queryDnssec((CharSequence)sepRecord.name, Record.TYPE.DS);
        if (dsResp == null) {
            LOGGER.fine("There is no DS record for " + sepRecord.name + ", server gives no result");
        } else {
            unverifiedReasons.addAll(dsResp.getUnverifiedReasons());
            for (Record record : dsResp.answerSection) {
                Record dsRecord = record.ifPossibleAs(DS.class);
                if (dsRecord == null) continue;
                DS ds = (DS)dsRecord.payloadData;
                if (dnskey.getKeyTag() != ds.keyTag) continue;
                delegation = ds;
                activeReasons = dsResp.getUnverifiedReasons();
                break;
            }
            if (delegation == null) {
                LOGGER.fine("There is no DS record for " + sepRecord.name + ", server gives empty result");
            }
        }
        if (delegation == null && this.dlv != null && !this.dlv.isChildOf(sepRecord.name) && (dlvResp = this.queryDnssec((CharSequence)DNSName.from((DNSName)sepRecord.name, (DNSName)this.dlv), Record.TYPE.DLV)) != null) {
            unverifiedReasons.addAll(dlvResp.getUnverifiedReasons());
            for (Record record : dlvResp.answerSection) {
                Record dlvRecord = record.ifPossibleAs(DLV.class);
                if (dlvRecord == null || ((DNSKEY)sepRecord.payloadData).getKeyTag() != ((DLV)dlvRecord.payloadData).keyTag) continue;
                LOGGER.fine("Found DLV for " + sepRecord.name + ", awesome.");
                delegation = (DS)dlvRecord.payloadData;
                activeReasons = dlvResp.getUnverifiedReasons();
                break;
            }
        }
        if (delegation != null) {
            UnverifiedReason unverifiedReason = this.verifier.verify(sepRecord, delegation);
            if (unverifiedReason != null) {
                unverifiedReasons.add(unverifiedReason);
            } else {
                unverifiedReasons = activeReasons;
            }
        } else if (unverifiedReasons.isEmpty()) {
            unverifiedReasons.add(new UnverifiedReason.NoTrustAnchorReason(sepRecord.name.ace));
        }
        return unverifiedReasons;
    }

    protected DNSMessage.Builder newQuestion(DNSMessage.Builder message) {
        message.getEdnsBuilder().setUdpPayloadSize(this.dataSource.getUdpPayloadSize()).setDnssecOk();
        message.setCheckingDisabled(true);
        return super.newQuestion(message);
    }

    protected String isResponseAcceptable(DNSMessage response) {
        boolean dnssecOk = response.isDnssecOk();
        if (!dnssecOk) {
            return "DNSSEC OK (DO) flag not set in response";
        }
        boolean checkingDisabled = response.checkingDisabled;
        if (!checkingDisabled) {
            return "CHECKING DISABLED (CD) flag not set in response";
        }
        return super.isResponseAcceptable(response);
    }

    public void addSecureEntryPoint(DNSName name, byte[] key) {
        this.knownSeps.put(name, key);
    }

    public void removeSecureEntryPoint(DNSName name) {
        this.knownSeps.remove(name);
    }

    public void clearSecureEntryPoints() {
        this.knownSeps.clear();
    }

    public boolean isStripSignatureRecords() {
        return this.stripSignatureRecords;
    }

    public void setStripSignatureRecords(boolean stripSignatureRecords) {
        this.stripSignatureRecords = stripSignatureRecords;
    }

    public void enableLookasideValidation() {
        this.configureLookasideValidation(DEFAULT_DLV);
    }

    public void disableLookasideValidation() {
        this.configureLookasideValidation(null);
    }

    public void configureLookasideValidation(DNSName dlv) {
        this.dlv = dlv;
    }

    private class VerifySignaturesResult {
        boolean sepSignatureRequired = false;
        boolean sepSignaturePresent = false;
        Set<UnverifiedReason> reasons = new HashSet<UnverifiedReason>();

        private VerifySignaturesResult() {
        }
    }
}

