/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dnssec;

import de.measite.minidns.DNSName;
import de.measite.minidns.Question;
import de.measite.minidns.Record;
import de.measite.minidns.dnssec.DNSSECValidationFailedException;
import de.measite.minidns.dnssec.DigestCalculator;
import de.measite.minidns.dnssec.SignatureVerifier;
import de.measite.minidns.dnssec.UnverifiedReason;
import de.measite.minidns.dnssec.algorithms.AlgorithmMap;
import de.measite.minidns.record.DNSKEY;
import de.measite.minidns.record.DS;
import de.measite.minidns.record.Data;
import de.measite.minidns.record.NSEC;
import de.measite.minidns.record.NSEC3;
import de.measite.minidns.record.RRSIG;
import de.measite.minidns.util.Base32;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class Verifier {
    private AlgorithmMap algorithmMap = AlgorithmMap.INSTANCE;

    Verifier() {
    }

    public UnverifiedReason verify(Record<DNSKEY> dnskeyRecord, DS ds) {
        byte[] digest;
        DNSKEY dnskey = (DNSKEY)dnskeyRecord.payloadData;
        DigestCalculator digestCalculator = this.algorithmMap.getDsDigestCalculator(ds.digestType);
        if (digestCalculator == null) {
            return new UnverifiedReason.AlgorithmNotSupportedReason(ds.digestTypeByte, "DS", dnskeyRecord);
        }
        byte[] dnskeyData = dnskey.toByteArray();
        byte[] dnskeyOwner = dnskeyRecord.name.getBytes();
        byte[] combined = new byte[dnskeyOwner.length + dnskeyData.length];
        System.arraycopy(dnskeyOwner, 0, combined, 0, dnskeyOwner.length);
        System.arraycopy(dnskeyData, 0, combined, dnskeyOwner.length, dnskeyData.length);
        try {
            digest = digestCalculator.digest(combined);
        }
        catch (Exception e) {
            return new UnverifiedReason.AlgorithmExceptionThrownReason(ds.digestType, "DS", dnskeyRecord, e);
        }
        if (!ds.digestEquals(digest)) {
            throw new DNSSECValidationFailedException(dnskeyRecord, "SEP is not properly signed by parent DS!");
        }
        return null;
    }

    public UnverifiedReason verify(List<Record<? extends Data>> records, RRSIG rrsig, DNSKEY key) {
        SignatureVerifier signatureVerifier = this.algorithmMap.getSignatureVerifier(rrsig.algorithm);
        if (signatureVerifier == null) {
            return new UnverifiedReason.AlgorithmNotSupportedReason(rrsig.algorithmByte, "RRSIG", records.get(0));
        }
        byte[] combine = Verifier.combine(rrsig, records);
        if (signatureVerifier.verify(combine, rrsig.signature, key.getKey())) {
            return null;
        }
        throw new DNSSECValidationFailedException(records, "Signature is invalid.");
    }

    public UnverifiedReason verifyNsec(Record<? extends Data> nsecRecord, Question q) {
        NSEC nsec = (NSEC)nsecRecord.payloadData;
        if (nsecRecord.name.equals((Object)q.name) && !Arrays.asList(nsec.types).contains(q.type)) {
            return null;
        }
        if (Verifier.nsecMatches(q.name, nsecRecord.name, nsec.next)) {
            return null;
        }
        return new UnverifiedReason.NSECDoesNotMatchReason(q, nsecRecord);
    }

    public UnverifiedReason verifyNsec3(CharSequence zone, Record<? extends Data> nsec3Record, Question q) {
        return this.verifyNsec3(DNSName.from((CharSequence)zone), nsec3Record, q);
    }

    public UnverifiedReason verifyNsec3(DNSName zone, Record<? extends Data> nsec3record, Question q) {
        NSEC3 nsec3 = (NSEC3)nsec3record.payloadData;
        DigestCalculator digestCalculator = this.algorithmMap.getNsecDigestCalculator(nsec3.hashAlgorithm);
        if (digestCalculator == null) {
            return new UnverifiedReason.AlgorithmNotSupportedReason(nsec3.hashAlgorithmByte, "NSEC3", nsec3record);
        }
        byte[] bytes = Verifier.nsec3hash(digestCalculator, nsec3.salt, q.name.getBytes(), nsec3.iterations);
        String s = Base32.encodeToString((byte[])bytes);
        DNSName computedNsec3Record = DNSName.from((String)(s + "." + zone));
        if (nsec3record.name.equals((Object)computedNsec3Record)) {
            for (Record.TYPE type : nsec3.types) {
                if (!type.equals((Object)q.type)) continue;
                return new UnverifiedReason.NSECDoesNotMatchReason(q, nsec3record);
            }
            return null;
        }
        if (Verifier.nsecMatches(s, nsec3record.name.getHostpart(), Base32.encodeToString((byte[])nsec3.nextHashed))) {
            return null;
        }
        return new UnverifiedReason.NSECDoesNotMatchReason(q, nsec3record);
    }

    static byte[] combine(RRSIG rrsig, List<Record<? extends Data>> records) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            rrsig.writePartialSignature(dos);
            DNSName sigName = records.get((int)0).name;
            if (!sigName.isRootLabel()) {
                if (sigName.getLabelCount() < rrsig.labels) {
                    throw new DNSSECValidationFailedException("Invalid RRsig record");
                }
                if (sigName.getLabelCount() > rrsig.labels) {
                    sigName = DNSName.from((String)("*." + sigName.stripToLabels((int)rrsig.labels)));
                }
            }
            ArrayList<byte[]> recordBytes = new ArrayList<byte[]>();
            for (Record<? extends Data> record : records) {
                Record ref = new Record(sigName, record.type, record.clazzValue, rrsig.originalTtl, record.payloadData);
                recordBytes.add(ref.toByteArray());
            }
            final int offset = sigName.size() + 10;
            Collections.sort(recordBytes, new Comparator<byte[]>(){

                @Override
                public int compare(byte[] b1, byte[] b2) {
                    for (int i = offset; i < b1.length && i < b2.length; ++i) {
                        if (b1[i] == b2[i]) continue;
                        return (b1[i] & 0xFF) - (b2[i] & 0xFF);
                    }
                    return b1.length - b2.length;
                }
            });
            for (byte[] recordByte : recordBytes) {
                dos.write(recordByte);
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    static boolean nsecMatches(String test, String lowerBound, String upperBound) {
        return Verifier.nsecMatches(DNSName.from((String)test), DNSName.from((String)lowerBound), DNSName.from((String)upperBound));
    }

    static boolean nsecMatches(DNSName test, DNSName lowerBound, DNSName upperBound) {
        int lowerParts = lowerBound.getLabelCount();
        int upperParts = upperBound.getLabelCount();
        int testParts = test.getLabelCount();
        if (testParts > lowerParts && !test.isChildOf(lowerBound) && test.stripToLabels(lowerParts).compareTo(lowerBound) < 0) {
            return false;
        }
        if (testParts <= lowerParts && test.compareTo(lowerBound.stripToLabels(testParts)) < 0) {
            return false;
        }
        if (testParts > upperParts && !test.isChildOf(upperBound) && test.stripToLabels(upperParts).compareTo(upperBound) > 0) {
            return false;
        }
        return testParts > upperParts || test.compareTo(upperBound.stripToLabels(testParts)) < 0;
    }

    static String stripToParts(String s, int parts) {
        if (s.isEmpty() && parts == 0) {
            return s;
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] split = s.split("\\.");
        if (split.length == parts) {
            return s;
        }
        if (split.length < parts) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = split.length - parts; i < split.length; ++i) {
            sb.append(split[i]);
            if (i == split.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    static byte[] nsec3hash(DigestCalculator digestCalculator, byte[] salt, byte[] data, int iterations) {
        while (iterations-- >= 0) {
            byte[] combined = new byte[data.length + salt.length];
            System.arraycopy(data, 0, combined, 0, data.length);
            System.arraycopy(salt, 0, combined, data.length, salt.length);
            data = digestCalculator.digest(combined);
        }
        return data;
    }
}

