/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.Record;
import de.measite.minidns.record.Data;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class TLSA
extends Data {
    public static final byte CERT_USAGE_CA_CONSTRAINT = 0;
    public static final byte CERT_USAGE_SERVICE_CERTIFICATE_CONSTRAINT = 1;
    public static final byte CRET_USAGE_TRUST_ANCHOR_ASSERTION = 2;
    public static final byte CERT_USAGE_DOMAIN_ISSUED_CERTIFICATE = 3;
    public static final byte SELECTOR_FULL_CERTIFICATE = 0;
    public static final byte SELECTOR_SUBJECT_PUBLIC_KEY_INFO = 1;
    public static final byte MATCHING_TYPE_NO_HASH = 0;
    public static final byte MATCHING_TYPE_SHA_256 = 1;
    public static final byte MATCHING_TYPE_SHA_512 = 2;
    public final byte certUsage;
    public final byte selector;
    public final byte matchingType;
    private final byte[] certificateAssociation;

    public static TLSA parse(DataInputStream dis, int length) throws IOException {
        byte certUsage = dis.readByte();
        byte selector = dis.readByte();
        byte matchingType = dis.readByte();
        byte[] certificateAssociation = new byte[length - 3];
        if (dis.read(certificateAssociation) != certificateAssociation.length) {
            throw new IOException();
        }
        return new TLSA(certUsage, selector, matchingType, certificateAssociation);
    }

    TLSA(byte certUsage, byte selector, byte matchingType, byte[] certificateAssociation) {
        this.certUsage = certUsage;
        this.selector = selector;
        this.matchingType = matchingType;
        this.certificateAssociation = certificateAssociation;
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.TLSA;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeByte(this.certUsage);
        dos.writeByte(this.selector);
        dos.writeByte(this.matchingType);
        dos.write(this.certificateAssociation);
    }

    public String toString() {
        return "" + this.certUsage + ' ' + this.selector + ' ' + this.matchingType + ' ' + new BigInteger(1, this.certificateAssociation).toString(16);
    }

    public byte[] getCertificateAssociation() {
        return (byte[])this.certificateAssociation.clone();
    }

    public boolean certificateAssociationEquals(byte[] otherCertificateAssociation) {
        return Arrays.equals(this.certificateAssociation, otherCertificateAssociation);
    }
}

