/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.export.external;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.tencent.smtt.export.external.LibraryLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class libwebp {
    private static final String LOGTAG = "[image]";
    private static libwebp mInstance = null;
    private static final int BITMAP_ALPHA_8 = 1;
    private static final int BITMAP_RGB_565 = 2;
    private static final int BITMAP_ARGB_4444 = 3;
    private static final int BITMAP_ARGB_8888 = 4;
    private int mBitmapType = 4;
    private static boolean mIsLoadLibSuccess = false;
    private static boolean isMultiCore = false;

    public static libwebp getInstance(Context context) {
        if (mInstance == null) {
            libwebp.loadWepLibraryIfNeed(context);
            mInstance = new libwebp();
        }
        return mInstance;
    }

    public static void loadWepLibraryIfNeed(Context context, String string) {
        if (!mIsLoadLibSuccess) {
            try {
                System.load(string + File.separator + "libwebp_base.so");
                mIsLoadLibSuccess = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Log.e((String)LOGTAG, (String)"Load WebP Library Error...: libwebp.java - loadWepLibraryIfNeed()");
            }
        }
    }

    public static void loadWepLibraryIfNeed(Context context) {
        if (!mIsLoadLibSuccess) {
            try {
                LibraryLoader.loadLibrary(context, "webp_base");
                mIsLoadLibSuccess = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Log.e((String)LOGTAG, (String)"Load WebP Library Error...: libwebp.java - loadWepLibraryIfNeed()");
            }
        }
    }

    private boolean isMultiCore() {
        String string = this.getCPUinfo();
        boolean bl = string.contains("processor");
        return bl;
    }

    private String getCPUinfo() {
        String string = "";
        try {
            String[] stringArray = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) != -1) {
                string = string + new String(byArray);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public int getInfo(byte[] byArray, int[] nArray, int[] nArray2) {
        if (!mIsLoadLibSuccess) {
            return 0;
        }
        return this.nativeGetInfo(byArray, nArray, nArray2);
    }

    public int[] decodeBase(byte[] byArray, int[] nArray, int[] nArray2) {
        if (!mIsLoadLibSuccess) {
            Log.e((String)LOGTAG, (String)"Load WebP Library Error...");
            return null;
        }
        return this.nativeDecode(byArray, isMultiCore, nArray, nArray2);
    }

    public int[] decodeBase_16bit(byte[] byArray, Bitmap.Config config) {
        if (!mIsLoadLibSuccess) {
            Log.e((String)LOGTAG, (String)"Load WebP Library Error...");
            return null;
        }
        switch (config) {
            case ARGB_4444: {
                this.mBitmapType = 3;
                break;
            }
            case RGB_565: {
                this.mBitmapType = 2;
                break;
            }
            default: {
                this.mBitmapType = 2;
            }
        }
        return this.nativeDecode_16bit(byArray, isMultiCore, this.mBitmapType);
    }

    public int[] decodeInto(byte[] byArray, int[] nArray, int[] nArray2) {
        if (!mIsLoadLibSuccess) {
            Log.e((String)LOGTAG, (String)"Load WebP Library Error...");
            return null;
        }
        return this.nativeDecodeInto(byArray, isMultiCore, nArray, nArray2);
    }

    public int[] incDecode(byte[] byArray, int[] nArray, int[] nArray2) {
        if (!mIsLoadLibSuccess) {
            Log.e((String)LOGTAG, (String)"Load WebP Library Error...");
            return null;
        }
        return this.nativeIDecode(byArray, isMultiCore, nArray, nArray2);
    }

    public native int nativeGetInfo(byte[] var1, int[] var2, int[] var3);

    public native int[] nativeDecode(byte[] var1, boolean var2, int[] var3, int[] var4);

    public native int[] nativeDecodeInto(byte[] var1, boolean var2, int[] var3, int[] var4);

    public native int[] nativeDecode_16bit(byte[] var1, boolean var2, int var3);

    public native int[] nativeIDecode(byte[] var1, boolean var2, int[] var3, int[] var4);

    public static int checkIsHuaModel() {
        String string = Build.BRAND.trim().toLowerCase();
        String string2 = Build.MODEL.trim().toLowerCase();
        int n2 = 0;
        if (string != null && string.length() > 0 && string.contains("huawei")) {
            n2 = 1;
        }
        if (string2 != null && string2.length() > 0 && string2.contains("huawei")) {
            n2 = 1;
        }
        return n2;
    }
}

