/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.export.external;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import dalvik.system.DexClassLoader;
import dalvik.system.VMStack;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DexLoader {
    private static final String JAVACORE_PACKAGE_PREFIX = "org.chromium";
    private static final String TAG = "DexLoader";
    private static final String TBS_FUSION_DEX = "tbs_jars_fusion_dex";
    private static final String TBS_WEBVIEW_DEX = "webview_dex";
    private static Boolean mUseTbsCorePrivateClassLoader = false;
    private DexClassLoader mClassLoader;

    public static void initTbsSettings(Map<String, Object> map) {
        if (map != null) {
            try {
                mUseTbsCorePrivateClassLoader = (Boolean)map.get("use_private_classloader");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private boolean shouldUseTbsCorePrivateClassLoader(String string) {
        if (!mUseTbsCorePrivateClassLoader.booleanValue()) {
            return false;
        }
        return string.contains(TBS_FUSION_DEX) || string.contains(TBS_WEBVIEW_DEX);
    }

    public DexLoader(String string, Context context, String[] stringArray, String string2) {
        this(string, context, stringArray, string2, null);
    }

    public DexLoader(String string, Context context, String[] stringArray, String string2, Map<String, Object> map) {
        DexLoader.initTbsSettings(map);
        ClassLoader classLoader = VMStack.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = context.getClassLoader();
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.mClassLoader = this.createDexClassLoader(stringArray[i2], string2, string, classLoader);
            classLoader = this.mClassLoader;
        }
    }

    public DexLoader(Context context, String[] stringArray, String string) {
        this(null, context, stringArray, string);
    }

    public DexLoader(Context context, String[] stringArray, String string, String string2) {
        ClassLoader classLoader = context.getClassLoader();
        String string3 = context.getApplicationInfo().nativeLibraryDir;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string3 = string3 + File.pathSeparator + string2;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.mClassLoader = this.createDexClassLoader(stringArray[i2], string, string3, classLoader);
            classLoader = this.mClassLoader;
        }
    }

    public DexLoader(Context context, String[] stringArray, String string, DexLoader dexLoader) {
        DexClassLoader dexClassLoader = dexLoader.getClassLoader();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            dexClassLoader = this.mClassLoader = this.createDexClassLoader(stringArray[i2], string, context.getApplicationInfo().nativeLibraryDir, (ClassLoader)dexClassLoader);
        }
    }

    public DexLoader(Context context, String string, String string2) {
        this(context, new String[]{string}, string2);
    }

    private DexClassLoader createDexClassLoader(String string, String string2, String string3, ClassLoader classLoader) {
        TbsCorePrivateClassLoader tbsCorePrivateClassLoader = null;
        tbsCorePrivateClassLoader = this.shouldUseTbsCorePrivateClassLoader(string) ? new TbsCorePrivateClassLoader(string, string2, string3, classLoader) : new DexClassLoader(string, string2, string3, classLoader);
        return tbsCorePrivateClassLoader;
    }

    public DexClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public Object newInstance(String string) {
        try {
            return this.mClassLoader.loadClass(string).newInstance();
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("create " + string + " instance failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object newInstance(String string, Class<?>[] classArray, Object ... objectArray) {
        try {
            return this.mClassLoader.loadClass(string).getConstructor(classArray).newInstance(objectArray);
        }
        catch (Throwable throwable) {
            if ("com.tencent.smtt.webkit.adapter.X5WebViewAdapter".equalsIgnoreCase(string)) {
                Log.e((String)this.getClass().getSimpleName(), (String)("'newInstance " + string + " failed"), (Throwable)throwable);
                return throwable;
            }
            Log.e((String)this.getClass().getSimpleName(), (String)("create '" + string + "' instance failed"), (Throwable)throwable);
            return null;
        }
    }

    public Class<?> loadClass(String string) {
        try {
            return this.mClassLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("loadClass '" + string + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object invokeStaticMethod(String string, String string2, Class<?>[] classArray, Object ... objectArray) {
        try {
            Method method = this.mClassLoader.loadClass(string).getMethod(string2, classArray);
            method.setAccessible(true);
            return method.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            if (string2 != null && string2.equalsIgnoreCase("initTesRuntimeEnvironment")) {
                Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' invoke static method '" + string2 + "' failed"), (Throwable)throwable);
                return throwable;
            }
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' invoke static method '" + string2 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object invokeMethod(Object object, String string, String string2, Class<?>[] classArray, Object ... objectArray) {
        try {
            Method method = this.mClassLoader.loadClass(string).getMethod(string2, classArray);
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' invoke method '" + string2 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public Object getStaticField(String string, String string2) {
        try {
            Field field = this.mClassLoader.loadClass(string).getField(string2);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' get field '" + string2 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    public void setStaticField(String string, String string2, Object object) {
        try {
            Field field = this.mClassLoader.loadClass(string).getField(string2);
            field.setAccessible(true);
            field.set(null, object);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string + "' set field '" + string2 + "' failed"), (Throwable)throwable);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TbsCorePrivateClassLoader
    extends DexClassLoader {
        public TbsCorePrivateClassLoader(String string, String string2, String string3, ClassLoader classLoader) {
            super(string, string2, string3, classLoader);
        }

        protected Class<?> loadClass(String string, boolean bl) {
            if (string != null && string.startsWith(DexLoader.JAVACORE_PACKAGE_PREFIX)) {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    ClassLoader classLoader;
                    try {
                        clazz = this.findClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz == null && (classLoader = this.getParent()) != null) {
                        clazz = classLoader.loadClass(string);
                    }
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }
}

