/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.net.InetAddress;
import java.util.List;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.dns.HostAddress;

public class SRVRecord
extends HostAddress
implements Comparable<SRVRecord> {
    private int weight;
    private int priority;

    public SRVRecord(String fqdn, int port, int priority, int weight, List<InetAddress> inetAddresses) {
        super(fqdn, port, inetAddresses);
        StringUtils.requireNotNullOrEmpty(fqdn, "The FQDN must not be null");
        if (weight < 0 || weight > 65535) {
            throw new IllegalArgumentException("DNS SRV records weight must be a 16-bit unsiged integer (i.e. between 0-65535. Weight was: " + weight);
        }
        if (priority < 0 || priority > 65535) {
            throw new IllegalArgumentException("DNS SRV records priority must be a 16-bit unsiged integer (i.e. between 0-65535. Priority was: " + priority);
        }
        this.priority = priority;
        this.weight = weight;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(SRVRecord other) {
        int res = other.priority - this.priority;
        if (res == 0) {
            res = this.weight - other.weight;
        }
        return res;
    }

    @Override
    public String toString() {
        return super.toString() + " prio:" + this.priority + ":w:" + this.weight;
    }
}

