/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.iterative;

import de.measite.minidns.DNSMessage;
import de.measite.minidns.Question;
import de.measite.minidns.iterative.IterativeClientException;
import de.measite.minidns.iterative.IterativeDNSClient;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ResolutionState {
    private final IterativeDNSClient recursiveDnsClient;
    private final HashMap<InetAddress, Set<Question>> map = new HashMap();
    private int steps;

    ResolutionState(IterativeDNSClient recursiveDnsClient) {
        this.recursiveDnsClient = recursiveDnsClient;
    }

    void recurse(InetAddress address, DNSMessage query) throws IterativeClientException.LoopDetected, IterativeClientException.MaxIterativeStepsReached {
        Question question = query.getQuestion();
        if (!this.map.containsKey(address)) {
            this.map.put(address, new HashSet());
        } else if (this.map.get(address).contains(question)) {
            throw new IterativeClientException.LoopDetected();
        }
        if (++this.steps > this.recursiveDnsClient.maxSteps) {
            throw new IterativeClientException.MaxIterativeStepsReached();
        }
        boolean isNew = this.map.get(address).add(question);
        assert (isNew);
    }

    void decrementSteps() {
        --this.steps;
    }
}

