/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.SHA1;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.BoBHash;
import org.jivesoftware.smackx.bob.BoBInfo;
import org.jivesoftware.smackx.bob.element.BoBIQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.LruCache;

public final class BoBManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:bob";
    private static final Map<XMPPConnection, BoBManager> INSTANCES;
    private static final LruCache<BoBHash, BoBData> BOB_CACHE;
    private final Map<BoBHash, BoBInfo> bobs = new ConcurrentHashMap<BoBHash, BoBInfo>();

    public static synchronized BoBManager getInstanceFor(XMPPConnection connection) {
        BoBManager bobManager = INSTANCES.get(connection);
        if (bobManager == null) {
            bobManager = new BoBManager(connection);
            INSTANCES.put(connection, bobManager);
        }
        return bobManager;
    }

    private BoBManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        serviceDiscoveryManager.addFeature(NAMESPACE);
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("data", NAMESPACE, IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                BoBIQ bobIQRequest = (BoBIQ)iqRequest;
                BoBInfo bobInfo = (BoBInfo)BoBManager.this.bobs.get(bobIQRequest.getBoBHash());
                if (bobInfo == null) {
                    return null;
                }
                BoBData bobData = bobInfo.getData();
                BoBIQ responseBoBIQ = new BoBIQ(bobIQRequest.getBoBHash(), bobData);
                responseBoBIQ.setType(IQ.Type.result);
                responseBoBIQ.setTo(bobIQRequest.getFrom());
                return responseBoBIQ;
            }
        });
    }

    public boolean isSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    public BoBData requestBoB(Jid to, BoBHash bobHash) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        BoBData bobData = (BoBData)BOB_CACHE.lookup((Object)bobHash);
        if (bobData != null) {
            return bobData;
        }
        BoBIQ requestBoBIQ = new BoBIQ(bobHash);
        requestBoBIQ.setType(IQ.Type.get);
        requestBoBIQ.setTo(to);
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        BoBIQ responseBoBIQ = (BoBIQ)connection.createStanzaCollectorAndSend((IQ)requestBoBIQ).nextResultOrThrow();
        bobData = responseBoBIQ.getBoBData();
        BOB_CACHE.put((Object)bobHash, (Object)bobData);
        return bobData;
    }

    public BoBInfo addBoB(BoBData bobData) {
        BoBHash bobHash = new BoBHash("sha1", SHA1.hex((byte[])bobData.getContent()));
        Set<BoBHash> bobHashes = Collections.singleton(bobHash);
        bobHashes = Collections.unmodifiableSet(bobHashes);
        BoBInfo bobInfo = new BoBInfo(bobHashes, bobData);
        this.bobs.put(bobHash, bobInfo);
        return bobInfo;
    }

    public BoBInfo removeBoB(BoBHash bobHash) {
        BoBInfo bobInfo = this.bobs.remove(bobHash);
        if (bobInfo == null) {
            return null;
        }
        for (BoBHash otherBobHash : bobInfo.getHashes()) {
            this.bobs.remove(otherBobHash);
        }
        return bobInfo;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                BoBManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, BoBManager>();
        BOB_CACHE = new LruCache(128);
    }
}

