/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.Record;
import de.measite.minidns.record.InternetAddressRR;
import java.io.DataInputStream;
import java.io.IOException;

public class AAAA
extends InternetAddressRR {
    @Override
    public Record.TYPE getType() {
        return Record.TYPE.AAAA;
    }

    public AAAA(byte[] ip) {
        super(ip);
        if (ip.length != 16) {
            throw new IllegalArgumentException("IPv6 address in AAAA record is always 16 byte");
        }
    }

    public static AAAA parse(DataInputStream dis) throws IOException {
        byte[] ip = new byte[16];
        dis.readFully(ip);
        return new AAAA(ip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ip.length; i += 2) {
            if (i != 0) {
                sb.append(':');
            }
            sb.append(Integer.toHexString(((this.ip[i] & 0xFF) << 8) + (this.ip[i + 1] & 0xFF)));
        }
        return sb.toString();
    }
}

