/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dnsserverlookup;

import de.measite.minidns.dnsserverlookup.AbstractDNSServerLookupMechanism;
import de.measite.minidns.dnsserverlookup.DNSServerLookupMechanism;
import de.measite.minidns.util.PlatformDetection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.logging.Level;

public class AndroidUsingExec
extends AbstractDNSServerLookupMechanism {
    public static final DNSServerLookupMechanism INSTANCE = new AndroidUsingExec();
    public static final int PRIORITY = 999;

    private AndroidUsingExec() {
        super(AndroidUsingExec.class.getSimpleName(), 999);
    }

    @Override
    public String[] getDnsServerAddresses() {
        try {
            Process process = Runtime.getRuntime().exec("getprop");
            InputStream inputStream = process.getInputStream();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inputStream));
            String line = null;
            HashSet<String> server = new HashSet<String>(6);
            while ((line = lnr.readLine()) != null) {
                InetAddress ip;
                int split = line.indexOf("]: [");
                if (split == -1) continue;
                String property = line.substring(1, split);
                String value = line.substring(split + 4, line.length() - 1);
                if (value.isEmpty() || !property.endsWith(".dns") && !property.endsWith(".dns1") && !property.endsWith(".dns2") && !property.endsWith(".dns3") && !property.endsWith(".dns4") || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0) continue;
                server.add(value);
            }
            if (server.size() > 0) {
                return server.toArray(new String[server.size()]);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception in findDNSByExec", e);
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return PlatformDetection.isAndroid();
    }
}

