/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jxmpp.xml.splitter.CompleteElementCallback;

public class XmlSplitter
extends Writer {
    protected final CompleteElementCallback completeElementCallback;
    private final StringBuilder elementBuffer;
    private final StringBuilder tokenBuffer = new StringBuilder(256);
    private final Map<String, String> attributes = new HashMap<String, String>();
    private int depth;
    private String qName;
    private String attributeName;
    private State state = State.START;

    public XmlSplitter(int bufferSize, CompleteElementCallback completeElementCallback) {
        this.elementBuffer = new StringBuilder(bufferSize);
        if (completeElementCallback == null) {
            throw new IllegalArgumentException();
        }
        this.completeElementCallback = completeElementCallback;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int cur = off; cur < off + len; ++cur) {
            this.processChar(cbuf[off + cur]);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public final int getCurrentElementSize() {
        return this.elementBuffer.length();
    }

    protected void onNextChar() throws IOException {
    }

    protected void onStartTag(String prefix, String localpart, Map<String, String> attributes) {
    }

    protected void onEndTag(String qName) {
    }

    protected final void newTopLevelElement() {
        this.depth = 0;
        this.elementBuffer.setLength(0);
    }

    private void processChar(char c) throws IOException {
        this.onNextChar();
        this.elementBuffer.append(c);
        block0 : switch (this.state) {
            case START: {
                switch (c) {
                    case '<': {
                        this.state = State.AFTER_TAG_RIGHT_ANGLE_BRACKET;
                    }
                }
                break;
            }
            case AFTER_TAG_RIGHT_ANGLE_BRACKET: {
                switch (c) {
                    case '/': {
                        this.state = State.IN_END_TAG;
                        break block0;
                    }
                    case '?': {
                        this.state = State.IN_DECLARATION;
                        break block0;
                    }
                    case '!': {
                        this.state = State.AFTER_COMMENT_BANG;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                this.state = State.IN_TAG_NAME;
                break;
            }
            case IN_TAG_NAME: {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        this.qName = this.getToken();
                        this.state = State.AFTER_START_NAME;
                        break block0;
                    }
                    case '/': {
                        this.qName = this.getToken();
                        this.onStartTagFinished();
                        this.state = State.IN_EMPTY_TAG;
                        break block0;
                    }
                    case '>': {
                        this.qName = this.getToken();
                        this.onStartTagFinished();
                        this.state = State.START;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                break;
            }
            case IN_END_TAG: {
                switch (c) {
                    case '>': {
                        this.onEndTagFinished();
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                break;
            }
            case AFTER_START_NAME: {
                switch (c) {
                    case '/': {
                        this.onStartTagFinished();
                        this.state = State.IN_EMPTY_TAG;
                        break block0;
                    }
                    case '>': {
                        this.onStartTagFinished();
                        this.state = State.START;
                        break block0;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                this.state = State.IN_ATTRIBUTE_NAME;
                break;
            }
            case IN_ATTRIBUTE_NAME: {
                switch (c) {
                    case '=': {
                        this.attributeName = this.getToken();
                        this.state = State.AFTER_ATTRIBUTE_EQUALS;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                break;
            }
            case AFTER_ATTRIBUTE_EQUALS: {
                switch (c) {
                    case '\"': 
                    case '\'': {
                        this.state = State.IN_ATTRIBUTE_VALUE;
                        break block0;
                    }
                }
                throw new IOException();
            }
            case IN_ATTRIBUTE_VALUE: {
                switch (c) {
                    case '\"': 
                    case '\'': {
                        this.attributes.put(this.attributeName, this.getToken());
                        this.state = State.AFTER_START_NAME;
                        break block0;
                    }
                }
                this.tokenBuffer.append(c);
                break;
            }
            case IN_EMPTY_TAG: {
                switch (c) {
                    case '>': {
                        this.onEndTagFinished();
                        break block0;
                    }
                }
                throw new IOException();
            }
            case AFTER_COMMENT_BANG: 
            case AFTER_COMMENT_DASH1: 
            case AFTER_COMMENT_DASH2: 
            case AFTER_COMMENT: 
            case AFTER_COMMENT_CLOSING_DASH1: 
            case AFTER_COMMENT_CLOSING_DASH2: 
            case IN_DECLARATION: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void onStartTagFinished() {
        ++this.depth;
        String prefix = XmlSplitter.extractPrefix(this.qName);
        String localpart = XmlSplitter.extractLocalpart(this.qName);
        this.onStartTag(prefix, localpart, this.attributes);
        this.attributes.clear();
    }

    private void onEndTagFinished() {
        String endTagName = this.getToken();
        if (endTagName.length() == 0) {
            endTagName = this.qName;
        }
        --this.depth;
        if (this.depth == 0) {
            String completeElement = this.elementBuffer.toString();
            this.elementBuffer.setLength(0);
            this.completeElementCallback.onCompleteElement(completeElement);
        }
        this.onEndTag(endTagName);
        this.state = State.START;
    }

    private final String getToken() {
        String token = this.tokenBuffer.toString();
        this.tokenBuffer.setLength(0);
        return token;
    }

    private static final String extractPrefix(String qName) {
        int index = qName.indexOf(58);
        return index > -1 ? qName.substring(0, index) : qName;
    }

    private static final String extractLocalpart(String qName) {
        int index = qName.indexOf(58);
        return index > -1 ? qName.substring(index + 1) : qName;
    }

    private static enum State {
        START,
        AFTER_TAG_RIGHT_ANGLE_BRACKET,
        IN_TAG_NAME,
        IN_DECLARATION,
        IN_END_TAG,
        AFTER_START_NAME,
        IN_EMPTY_TAG,
        IN_ATTRIBUTE_NAME,
        AFTER_ATTRIBUTE_EQUALS,
        IN_ATTRIBUTE_VALUE,
        AFTER_COMMENT_BANG,
        AFTER_COMMENT_DASH1,
        AFTER_COMMENT_DASH2,
        AFTER_COMMENT,
        AFTER_COMMENT_CLOSING_DASH1,
        AFTER_COMMENT_CLOSING_DASH2;

    }
}

