/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns;

import de.measite.minidns.AbstractDNSClient;
import de.measite.minidns.DNSCache;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.dnsserverlookup.AndroidUsingExec;
import de.measite.minidns.dnsserverlookup.AndroidUsingReflection;
import de.measite.minidns.dnsserverlookup.DNSServerLookupMechanism;
import de.measite.minidns.dnsserverlookup.UnixUsingEtcResolvConf;
import de.measite.minidns.util.CollectionsUtil;
import de.measite.minidns.util.InetAddressUtil;
import de.measite.minidns.util.MultipleIoException;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;

public class DNSClient
extends AbstractDNSClient {
    static final List<DNSServerLookupMechanism> LOOKUP_MECHANISMS = new ArrayList<DNSServerLookupMechanism>();
    static final Set<Inet4Address> STATIC_IPV4_DNS_SERVERS = new CopyOnWriteArraySet<Inet4Address>();
    static final Set<Inet6Address> STATIC_IPV6_DNS_SERVERS = new CopyOnWriteArraySet<Inet6Address>();
    private static final Set<String> blacklistedDnsServers;
    private final Set<InetAddress> nonRaServers = Collections.newSetFromMap(new ConcurrentHashMap(4));
    private boolean askForDnssec = false;
    private boolean disableResultFilter = false;
    private boolean useHardcodedDnsServers = true;

    public DNSClient() {
    }

    public DNSClient(DNSCache dnsCache) {
        super(dnsCache);
    }

    @Override
    protected DNSMessage.Builder newQuestion(DNSMessage.Builder message) {
        message.setRecursionDesired(true);
        message.getEdnsBuilder().setUdpPayloadSize(this.dataSource.getUdpPayloadSize()).setDnssecOk(this.askForDnssec);
        return message;
    }

    @Override
    public DNSMessage query(DNSMessage.Builder queryBuilder) throws IOException {
        DNSMessage responseMessage;
        DNSMessage q = this.newQuestion(queryBuilder).build();
        DNSMessage dNSMessage = responseMessage = this.cache == null ? null : this.cache.get(q);
        if (responseMessage != null) {
            return responseMessage;
        }
        String[] dnsServerStrings = DNSClient.findDNS();
        int dnsServerCount = dnsServerStrings == null ? 0 : dnsServerStrings.length;
        ArrayList<InetAddress> dnsServerAddresses = new ArrayList<InetAddress>(dnsServerCount + 2);
        for (String dnsServerString : dnsServerStrings) {
            if (dnsServerString == null || dnsServerString.isEmpty()) {
                LOGGER.finest("findDns() returned null or empty string as dns server");
                continue;
            }
            InetAddress dnsServerAddress = InetAddress.getByName(dnsServerString);
            dnsServerAddresses.add(dnsServerAddress);
        }
        InetAddress[] selectedHardcodedDnsServerAddresses = new InetAddress[2];
        if (this.useHardcodedDnsServers) {
            InetAddress primaryHardcodedDnsServer = null;
            InetAddress secondaryHardcodedDnsServer = null;
            switch (ipVersionSetting) {
                case v4v6: {
                    primaryHardcodedDnsServer = this.getRandomHardcodedIpv4DnsServer();
                    secondaryHardcodedDnsServer = this.getRandomHarcodedIpv6DnsServer();
                    break;
                }
                case v6v4: {
                    primaryHardcodedDnsServer = this.getRandomHarcodedIpv6DnsServer();
                    secondaryHardcodedDnsServer = this.getRandomHardcodedIpv4DnsServer();
                    break;
                }
                case v4only: {
                    primaryHardcodedDnsServer = this.getRandomHardcodedIpv4DnsServer();
                    break;
                }
                case v6only: {
                    primaryHardcodedDnsServer = this.getRandomHarcodedIpv6DnsServer();
                }
            }
            selectedHardcodedDnsServerAddresses[0] = primaryHardcodedDnsServer;
            selectedHardcodedDnsServerAddresses[1] = secondaryHardcodedDnsServer;
        }
        for (InetAddress selectedHardcodedDnsServerAddress : selectedHardcodedDnsServerAddresses) {
            if (selectedHardcodedDnsServerAddress == null) continue;
            dnsServerAddresses.add(selectedHardcodedDnsServerAddress);
        }
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>(dnsServerAddresses.size());
        block13: for (InetAddress dns : dnsServerAddresses) {
            if (this.nonRaServers.contains(dns)) {
                LOGGER.finer("Skipping " + dns + " because it was marked as \"recursion not available\"");
                continue;
            }
            try {
                responseMessage = this.query(q, dns);
                if (responseMessage == null) continue;
                if (!responseMessage.recursionAvailable) {
                    boolean newRaServer = this.nonRaServers.add(dns);
                    if (!newRaServer) continue;
                    LOGGER.warning("The DNS server " + dns + " returned a response without the \"recursion available\" (RA) flag set. This likely indicates a misconfiguration because the server is not suitable for DNS resolution");
                    continue;
                }
                if (this.disableResultFilter) {
                    return responseMessage;
                }
                switch (responseMessage.responseCode) {
                    case NO_ERROR: 
                    case NX_DOMAIN: {
                        break;
                    }
                    default: {
                        String warning = "Response from " + dns + " asked for " + q.getQuestion() + " with error code: " + (Object)((Object)responseMessage.responseCode) + '.';
                        if (!LOGGER.isLoggable(Level.FINE)) {
                            warning = warning + "\n" + responseMessage;
                        }
                        LOGGER.warning(warning);
                        continue block13;
                    }
                }
                return responseMessage;
            }
            catch (IOException ioe) {
                ioExceptions.add(ioe);
            }
        }
        MultipleIoException.throwIfRequired(ioExceptions);
        return null;
    }

    public static synchronized String[] findDNS() {
        String[] resArray = null;
        for (DNSServerLookupMechanism mechanism : LOOKUP_MECHANISMS) {
            resArray = mechanism.getDnsServerAddresses();
            if (resArray == null) continue;
            ArrayList<String> res = new ArrayList<String>(Arrays.asList(resArray));
            Iterator it = res.iterator();
            while (it.hasNext()) {
                String potentialDnsServer = (String)it.next();
                if (!blacklistedDnsServers.contains(potentialDnsServer)) continue;
                LOGGER.fine("The DNS server lookup mechanism '" + mechanism.getName() + "' returned a blacklisted result: '" + potentialDnsServer + "'");
                it.remove();
            }
            if (res.isEmpty()) continue;
            break;
        }
        return resArray;
    }

    public static synchronized void addDnsServerLookupMechanism(DNSServerLookupMechanism dnsServerLookup) {
        if (!dnsServerLookup.isAvailable()) {
            LOGGER.fine("Not adding " + dnsServerLookup.getName() + " as it is not available.");
            return;
        }
        LOOKUP_MECHANISMS.add(dnsServerLookup);
        Collections.sort(LOOKUP_MECHANISMS);
    }

    public static synchronized boolean removeDNSServerLookupMechanism(DNSServerLookupMechanism dnsServerLookup) {
        return LOOKUP_MECHANISMS.remove(dnsServerLookup);
    }

    public static boolean addBlacklistedDnsServer(String dnsServer) {
        return blacklistedDnsServers.add(dnsServer);
    }

    public static boolean removeBlacklistedDnsServer(String dnsServer) {
        return blacklistedDnsServers.remove(dnsServer);
    }

    public boolean isAskForDnssec() {
        return this.askForDnssec;
    }

    public void setAskForDnssec(boolean askForDnssec) {
        this.askForDnssec = askForDnssec;
    }

    public boolean isDisableResultFilter() {
        return this.disableResultFilter;
    }

    public void setDisableResultFilter(boolean disableResultFilter) {
        this.disableResultFilter = disableResultFilter;
    }

    public boolean isUseHardcodedDnsServersEnabled() {
        return this.useHardcodedDnsServers;
    }

    public void setUseHardcodedDnsServers(boolean useHardcodedDnsServers) {
        this.useHardcodedDnsServers = useHardcodedDnsServers;
    }

    public InetAddress getRandomHardcodedIpv4DnsServer() {
        return CollectionsUtil.getRandomFrom(STATIC_IPV4_DNS_SERVERS, this.insecureRandom);
    }

    public InetAddress getRandomHarcodedIpv6DnsServer() {
        return CollectionsUtil.getRandomFrom(STATIC_IPV6_DNS_SERVERS, this.insecureRandom);
    }

    static {
        DNSClient.addDnsServerLookupMechanism(AndroidUsingExec.INSTANCE);
        DNSClient.addDnsServerLookupMechanism(AndroidUsingReflection.INSTANCE);
        DNSClient.addDnsServerLookupMechanism(UnixUsingEtcResolvConf.INSTANCE);
        try {
            Inet4Address googleV4Dns = InetAddressUtil.ipv4From("8.8.8.8");
            STATIC_IPV4_DNS_SERVERS.add(googleV4Dns);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Could not add static IPv4 DNS Server", e);
        }
        try {
            Inet6Address googleV6Dns = InetAddressUtil.ipv6From("[2001:4860:4860::8888]");
            STATIC_IPV6_DNS_SERVERS.add(googleV6Dns);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Could not add static IPv6 DNS Server", e);
        }
        blacklistedDnsServers = Collections.newSetFromMap(new ConcurrentHashMap(4));
    }
}

