/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public class RosterUtil {
    public static void waitUntilOtherEntityIsSubscribed(Roster roster, BareJid otherEntity, long timeoutMillis) throws InterruptedException, TimeoutException {
        Date deadline = new Date(System.currentTimeMillis() + timeoutMillis);
        RosterUtil.waitUntilOtherEntityIsSubscribed(roster, otherEntity, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitUntilOtherEntityIsSubscribed(Roster roster, BareJid otherEntity, Date deadline) throws InterruptedException, TimeoutException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition maybeSubscribed = lock.newCondition();
        AbstractRosterListener rosterListener = new AbstractRosterListener(){

            private void signal() {
                lock.lock();
                try {
                    maybeSubscribed.signal();
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void entriesAdded(Collection<Jid> addresses) {
                this.signal();
            }

            @Override
            public void entriesUpdated(Collection<Jid> addresses) {
                this.signal();
            }
        };
        roster.addRosterListener(rosterListener);
        boolean stillWaiting = true;
        lock.lock();
        try {
            while (!roster.isSubscribedToMyPresence((Jid)otherEntity)) {
                if (!stillWaiting) {
                    throw new TimeoutException();
                }
                stillWaiting = maybeSubscribed.awaitUntil(deadline);
            }
        }
        finally {
            lock.unlock();
            roster.removeRosterListener(rosterListener);
        }
    }

    public static void askForSubscriptionIfRequired(Roster roster, BareJid jid) throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException {
        RosterEntry entry = roster.getEntry(jid);
        if (entry == null || !entry.canSeeHisPresence() && !entry.isSubscriptionPending()) {
            roster.sendSubscriptionRequest(jid);
        }
    }

    public static void ensureNotSubscribedToEachOther(XMPPConnection connectionOne, XMPPConnection connectionTwo) throws SmackException.NotConnectedException, InterruptedException {
        Roster rosterOne = Roster.getInstanceFor(connectionOne);
        BareJid jidOne = connectionOne.getUser().asBareJid();
        Roster rosterTwo = Roster.getInstanceFor(connectionTwo);
        BareJid jidTwo = connectionTwo.getUser().asBareJid();
        RosterUtil.ensureNotSubscribed(rosterOne, jidTwo);
        RosterUtil.ensureNotSubscribed(rosterTwo, jidOne);
    }

    public static void ensureNotSubscribed(Roster roster, BareJid jid) throws SmackException.NotConnectedException, InterruptedException {
        RosterEntry entry = roster.getEntry(jid);
        if (entry != null && entry.canSeeMyPresence()) {
            entry.cancelSubscription();
        }
    }

    public static void ensureSubscribed(XMPPConnection connectionOne, XMPPConnection connectionTwo, long timeout) throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, TimeoutException {
        RosterUtil.ensureSubscribedTo(connectionOne, connectionTwo, timeout);
        RosterUtil.ensureSubscribedTo(connectionTwo, connectionOne, timeout);
    }

    public static void ensureSubscribedTo(XMPPConnection connectionOne, XMPPConnection connectionTwo, long timeout) throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, TimeoutException {
        Date deadline = new Date(System.currentTimeMillis() + timeout);
        RosterUtil.ensureSubscribedTo(connectionOne, connectionTwo, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureSubscribedTo(XMPPConnection connectionOne, XMPPConnection connectionTwo, Date deadline) throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, TimeoutException {
        BareJid jidTwo;
        Roster rosterOne = Roster.getInstanceFor(connectionOne);
        if (rosterOne.iAmSubscribedTo((Jid)(jidTwo = connectionTwo.getUser().asBareJid()))) {
            return;
        }
        final BareJid jidOne = connectionOne.getUser().asBareJid();
        SubscribeListener subscribeListener = new SubscribeListener(){

            @Override
            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                if (from.equals((CharSequence)jidOne)) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return null;
            }
        };
        Roster rosterTwo = Roster.getInstanceFor(connectionTwo);
        rosterTwo.addSubscribeListener(subscribeListener);
        try {
            rosterOne.sendSubscriptionRequest(jidTwo);
            RosterUtil.waitUntilOtherEntityIsSubscribed(rosterTwo, jidOne, deadline);
        }
        finally {
            rosterTwo.removeSubscribeListener(subscribeListener);
        }
    }
}

