/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.DNSSECConstants;
import de.measite.minidns.Record;
import de.measite.minidns.record.Data;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class DS
extends Data {
    public final int keyTag;
    public final DNSSECConstants.SignatureAlgorithm algorithm;
    public final byte algorithmByte;
    public final DNSSECConstants.DigestAlgorithm digestType;
    public final byte digestTypeByte;
    protected final byte[] digest;
    private BigInteger digestBigIntCache;
    private String digestHexCache;

    public static DS parse(DataInputStream dis, int length) throws IOException {
        int keyTag = dis.readUnsignedShort();
        byte algorithm = dis.readByte();
        byte digestType = dis.readByte();
        byte[] digest = new byte[length - 4];
        if (dis.read(digest) != digest.length) {
            throw new IOException();
        }
        return new DS(keyTag, algorithm, digestType, digest);
    }

    private DS(int keyTag, DNSSECConstants.SignatureAlgorithm algorithm, byte algorithmByte, DNSSECConstants.DigestAlgorithm digestType, byte digestTypeByte, byte[] digest) {
        this.keyTag = keyTag;
        assert (algorithmByte == (algorithm != null ? algorithm.number : algorithmByte));
        this.algorithmByte = algorithmByte;
        DNSSECConstants.SignatureAlgorithm signatureAlgorithm = this.algorithm = algorithm != null ? algorithm : DNSSECConstants.SignatureAlgorithm.forByte(algorithmByte);
        assert (digestTypeByte == (digestType != null ? digestType.value : digestTypeByte));
        this.digestTypeByte = digestTypeByte;
        DNSSECConstants.DigestAlgorithm digestAlgorithm = this.digestType = digestType != null ? digestType : DNSSECConstants.DigestAlgorithm.forByte(digestTypeByte);
        assert (digest != null);
        this.digest = digest;
    }

    public DS(int keyTag, byte algorithm, byte digestType, byte[] digest) {
        this(keyTag, null, algorithm, null, digestType, digest);
    }

    public DS(int keyTag, DNSSECConstants.SignatureAlgorithm algorithm, byte digestType, byte[] digest) {
        this(keyTag, algorithm, algorithm.number, null, digestType, digest);
    }

    public DS(int keyTag, DNSSECConstants.SignatureAlgorithm algorithm, DNSSECConstants.DigestAlgorithm digestType, byte[] digest) {
        this(keyTag, algorithm, algorithm.number, digestType, digestType.value, digest);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.DS;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeShort(this.keyTag);
        dos.writeByte(this.algorithmByte);
        dos.writeByte(this.digestTypeByte);
        dos.write(this.digest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.keyTag).append(' ').append((Object)this.algorithm).append(' ').append((Object)this.digestType).append(' ').append(new BigInteger(1, this.digest).toString(16).toUpperCase());
        return sb.toString();
    }

    public BigInteger getDigestBigInteger() {
        if (this.digestBigIntCache == null) {
            this.digestBigIntCache = new BigInteger(1, this.digest);
        }
        return this.digestBigIntCache;
    }

    public String getDigestHex() {
        if (this.digestHexCache == null) {
            this.digestHexCache = this.getDigestBigInteger().toString(16).toUpperCase();
        }
        return this.digestHexCache;
    }

    public boolean digestEquals(byte[] otherDigest) {
        return Arrays.equals(this.digest, otherDigest);
    }
}

