/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns;

import de.measite.minidns.DNSMessage;
import de.measite.minidns.DNSName;
import de.measite.minidns.Record;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Question {
    public final DNSName name;
    public final Record.TYPE type;
    public final Record.CLASS clazz;
    private final boolean unicastQuery;
    private byte[] byteArray;

    public Question(CharSequence name, Record.TYPE type, Record.CLASS clazz, boolean unicastQuery) {
        this(DNSName.from(name), type, clazz, unicastQuery);
    }

    public Question(DNSName name, Record.TYPE type, Record.CLASS clazz, boolean unicastQuery) {
        assert (name != null);
        assert (type != null);
        assert (clazz != null);
        this.name = name;
        this.type = type;
        this.clazz = clazz;
        this.unicastQuery = unicastQuery;
    }

    public Question(DNSName name, Record.TYPE type, Record.CLASS clazz) {
        this(name, type, clazz, false);
    }

    public Question(DNSName name, Record.TYPE type) {
        this(name, type, Record.CLASS.IN);
    }

    public Question(CharSequence name, Record.TYPE type, Record.CLASS clazz) {
        this(DNSName.from(name), type, clazz);
    }

    public Question(CharSequence name, Record.TYPE type) {
        this(DNSName.from(name), type);
    }

    public Question(DataInputStream dis, byte[] data) throws IOException {
        this.name = DNSName.parse(dis, data);
        this.type = Record.TYPE.getType(dis.readUnsignedShort());
        this.clazz = Record.CLASS.getClass(dis.readUnsignedShort());
        this.unicastQuery = false;
    }

    public byte[] toByteArray() {
        if (this.byteArray == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                this.name.writeToStream(dos);
                dos.writeShort(this.type.getValue());
                dos.writeShort(this.clazz.getValue() | (this.unicastQuery ? 32768 : 0));
                dos.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.byteArray = baos.toByteArray();
        }
        return this.byteArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Question)) {
            return false;
        }
        byte[] t = this.toByteArray();
        byte[] o = ((Question)other).toByteArray();
        return Arrays.equals(t, o);
    }

    public String toString() {
        return this.name + ".\t" + (Object)((Object)this.clazz) + '\t' + (Object)((Object)this.type);
    }

    public DNSMessage.Builder asMessageBuilder() {
        DNSMessage.Builder builder = DNSMessage.builder();
        builder.setQuestion(this);
        return builder;
    }

    public DNSMessage asQueryMessage() {
        return this.asMessageBuilder().build();
    }
}

