/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static InputStream getStreamForUrl(String url, ClassLoader loader) throws MalformedURLException, IOException {
        URI fileUri = URI.create(url);
        if (fileUri.getScheme() == null) {
            throw new MalformedURLException("No protocol found in file URL: " + url);
        }
        if (fileUri.getScheme().equals("classpath")) {
            List<ClassLoader> classLoaders = FileUtils.getClassLoaders();
            if (loader != null) {
                classLoaders.add(0, loader);
            }
            for (ClassLoader classLoader : classLoaders) {
                InputStream is = classLoader.getResourceAsStream(fileUri.getSchemeSpecificPart());
                if (is == null) continue;
                return is;
            }
        } else {
            return fileUri.toURL().openStream();
        }
        return null;
    }

    public static List<ClassLoader> getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{FileUtils.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(classLoaders.length);
        for (ClassLoader classLoader : classLoaders) {
            if (classLoader == null) continue;
            loaders.add(classLoader);
        }
        return loaders;
    }

    public static boolean addLines(String url, Set<String> set) throws MalformedURLException, IOException {
        String line;
        InputStream is = FileUtils.getStreamForUrl(url, null);
        if (is == null) {
            return false;
        }
        InputStreamReader sr = new InputStreamReader(is, "UTF-8");
        BufferedReader br = new BufferedReader(sr);
        while ((line = br.readLine()) != null) {
            set.add(line);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileOrThrow(File file) throws FileNotFoundException, IOException {
        try (FileReader reader = null;){
            int len;
            reader = new FileReader(file);
            char[] buf = new char[8192];
            StringBuilder s = new StringBuilder();
            while ((len = reader.read(buf)) >= 0) {
                s.append(buf, 0, len);
            }
            String string = s.toString();
            return string;
        }
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFileOrThrow(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINE, "readFile", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "readFile", e);
        }
        return null;
    }

    public static void writeFileOrThrow(File file, CharSequence content) throws IOException {
        try (FileWriter writer = new FileWriter(file, false);){
            writer.write(content.toString());
        }
    }

    public static boolean writeFile(File file, CharSequence content) {
        try {
            FileUtils.writeFileOrThrow(file, content);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "writeFile", e);
            return false;
        }
    }
}

