/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns;

import de.measite.minidns.EDNS;
import de.measite.minidns.Question;
import de.measite.minidns.Record;
import de.measite.minidns.record.Data;
import de.measite.minidns.record.OPT;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DNSMessage {
    private static final Logger LOGGER = Logger.getLogger(DNSMessage.class.getName());
    public final int id;
    public final OPCODE opcode;
    public final RESPONSE_CODE responseCode;
    public final boolean qr;
    public final boolean authoritativeAnswer;
    public final boolean truncated;
    public final boolean recursionDesired;
    public final boolean recursionAvailable;
    public final boolean authenticData;
    public final boolean checkingDisabled;
    public final List<Question> questions;
    public final List<Record<? extends Data>> answerSection;
    public final List<Record<? extends Data>> authoritySection;
    public final List<Record<? extends Data>> additionalSection;
    public final int optRrPosition;
    private EDNS edns;
    public final long receiveTimestamp;
    private byte[] byteCache;
    private String toStringCache;
    private String terminalOutputCache;
    private DNSMessage normalizedVersionCache;
    private transient Integer hashCodeCache;

    protected DNSMessage(Builder builder) {
        this.id = builder.id;
        this.opcode = builder.opcode;
        this.responseCode = builder.responseCode;
        this.receiveTimestamp = builder.receiveTimestamp;
        this.qr = builder.query;
        this.authoritativeAnswer = builder.authoritativeAnswer;
        this.truncated = builder.truncated;
        this.recursionDesired = builder.recursionDesired;
        this.recursionAvailable = builder.recursionAvailable;
        this.authenticData = builder.authenticData;
        this.checkingDisabled = builder.checkingDisabled;
        if (builder.questions == null) {
            this.questions = Collections.emptyList();
        } else {
            ArrayList q = new ArrayList(builder.questions.size());
            q.addAll(builder.questions);
            this.questions = Collections.unmodifiableList(q);
        }
        if (builder.answers == null) {
            this.answerSection = Collections.emptyList();
        } else {
            ArrayList a = new ArrayList(builder.answers.size());
            a.addAll(builder.answers);
            this.answerSection = Collections.unmodifiableList(a);
        }
        if (builder.nameserverRecords == null) {
            this.authoritySection = Collections.emptyList();
        } else {
            ArrayList n = new ArrayList(builder.nameserverRecords.size());
            n.addAll(builder.nameserverRecords);
            this.authoritySection = Collections.unmodifiableList(n);
        }
        if (builder.additionalResourceRecords == null && builder.ednsBuilder == null) {
            this.additionalSection = Collections.emptyList();
        } else {
            int size = 0;
            if (builder.additionalResourceRecords != null) {
                size += builder.additionalResourceRecords.size();
            }
            if (builder.ednsBuilder != null) {
                ++size;
            }
            ArrayList<Record<OPT>> a = new ArrayList<Record<OPT>>(size);
            if (builder.additionalResourceRecords != null) {
                a.addAll(builder.additionalResourceRecords);
            }
            if (builder.ednsBuilder != null) {
                EDNS edns;
                this.edns = edns = builder.ednsBuilder.build();
                a.add(edns.asRecord());
            }
            this.additionalSection = Collections.unmodifiableList(a);
        }
        this.optRrPosition = DNSMessage.getOptRrPosition(this.additionalSection);
        if (this.optRrPosition != -1) {
            for (int i = this.optRrPosition + 1; i < this.additionalSection.size(); ++i) {
                if (this.additionalSection.get((int)i).type != Record.TYPE.OPT) continue;
                throw new IllegalArgumentException("There must be only one OPT pseudo RR in the additional section");
            }
        }
    }

    public DNSMessage(byte[] data) throws IOException {
        int i;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        this.id = dis.readUnsignedShort();
        int header = dis.readUnsignedShort();
        this.qr = (header >> 15 & 1) == 1;
        this.opcode = OPCODE.getOpcode(header >> 11 & 0xF);
        this.authoritativeAnswer = (header >> 10 & 1) == 1;
        this.truncated = (header >> 9 & 1) == 1;
        this.recursionDesired = (header >> 8 & 1) == 1;
        this.recursionAvailable = (header >> 7 & 1) == 1;
        this.authenticData = (header >> 5 & 1) == 1;
        this.checkingDisabled = (header >> 4 & 1) == 1;
        this.responseCode = RESPONSE_CODE.getResponseCode(header & 0xF);
        this.receiveTimestamp = System.currentTimeMillis();
        int questionCount = dis.readUnsignedShort();
        int answerCount = dis.readUnsignedShort();
        int nameserverCount = dis.readUnsignedShort();
        int additionalResourceRecordCount = dis.readUnsignedShort();
        this.questions = new ArrayList<Question>(questionCount);
        for (i = 0; i < questionCount; ++i) {
            this.questions.add(new Question(dis, data));
        }
        this.answerSection = new ArrayList<Record<? extends Data>>(answerCount);
        for (i = 0; i < answerCount; ++i) {
            this.answerSection.add(Record.parse(dis, data));
        }
        this.authoritySection = new ArrayList<Record<? extends Data>>(nameserverCount);
        for (i = 0; i < nameserverCount; ++i) {
            this.authoritySection.add(Record.parse(dis, data));
        }
        this.additionalSection = new ArrayList<Record<? extends Data>>(additionalResourceRecordCount);
        for (i = 0; i < additionalResourceRecordCount; ++i) {
            this.additionalSection.add(Record.parse(dis, data));
        }
        this.optRrPosition = DNSMessage.getOptRrPosition(this.additionalSection);
    }

    private DNSMessage(DNSMessage message) {
        this.id = 0;
        this.qr = message.qr;
        this.opcode = message.opcode;
        this.authoritativeAnswer = message.authoritativeAnswer;
        this.truncated = message.truncated;
        this.recursionDesired = message.recursionDesired;
        this.recursionAvailable = message.recursionAvailable;
        this.authenticData = message.authenticData;
        this.checkingDisabled = message.checkingDisabled;
        this.responseCode = message.responseCode;
        this.receiveTimestamp = message.receiveTimestamp;
        this.questions = message.questions;
        this.answerSection = message.answerSection;
        this.authoritySection = message.authoritySection;
        this.additionalSection = message.additionalSection;
        this.optRrPosition = message.optRrPosition;
    }

    private static int getOptRrPosition(List<Record<? extends Data>> additionalSection) {
        int optRrPosition = -1;
        for (int i = 0; i < additionalSection.size(); ++i) {
            Record<? extends Data> record = additionalSection.get(i);
            if (record.type != Record.TYPE.OPT) continue;
            optRrPosition = i;
            break;
        }
        return optRrPosition;
    }

    public byte[] toArray() throws IOException {
        return (byte[])this.serialize().clone();
    }

    public DatagramPacket asDatagram(InetAddress address, int port) {
        byte[] bytes = this.serialize();
        return new DatagramPacket(bytes, bytes.length, address, port);
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        byte[] bytes = this.serialize();
        dataOutputStream.writeShort(bytes.length);
        dataOutputStream.write(bytes);
    }

    private byte[] serialize() {
        if (this.byteCache != null) {
            return this.byteCache;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DataOutputStream dos = new DataOutputStream(baos);
        int header = this.calculateHeaderBitmap();
        try {
            dos.writeShort((short)this.id);
            dos.writeShort((short)header);
            if (this.questions == null) {
                dos.writeShort(0);
            } else {
                dos.writeShort((short)this.questions.size());
            }
            if (this.answerSection == null) {
                dos.writeShort(0);
            } else {
                dos.writeShort((short)this.answerSection.size());
            }
            if (this.authoritySection == null) {
                dos.writeShort(0);
            } else {
                dos.writeShort((short)this.authoritySection.size());
            }
            if (this.additionalSection == null) {
                dos.writeShort(0);
            } else {
                dos.writeShort((short)this.additionalSection.size());
            }
            if (this.questions != null) {
                for (Question question : this.questions) {
                    dos.write(question.toByteArray());
                }
            }
            if (this.answerSection != null) {
                for (Record record : this.answerSection) {
                    dos.write(record.toByteArray());
                }
            }
            if (this.authoritySection != null) {
                for (Record record : this.authoritySection) {
                    dos.write(record.toByteArray());
                }
            }
            if (this.additionalSection != null) {
                for (Record record : this.additionalSection) {
                    dos.write(record.toByteArray());
                }
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.byteCache = baos.toByteArray();
        return this.byteCache;
    }

    int calculateHeaderBitmap() {
        int header = 0;
        if (this.qr) {
            header += 32768;
        }
        if (this.opcode != null) {
            header += this.opcode.getValue() << 11;
        }
        if (this.authoritativeAnswer) {
            header += 1024;
        }
        if (this.truncated) {
            header += 512;
        }
        if (this.recursionDesired) {
            header += 256;
        }
        if (this.recursionAvailable) {
            header += 128;
        }
        if (this.authenticData) {
            header += 32;
        }
        if (this.checkingDisabled) {
            header += 16;
        }
        if (this.responseCode != null) {
            header += this.responseCode.getValue();
        }
        return header;
    }

    public Question getQuestion() {
        return this.questions.get(0);
    }

    public List<Question> copyQuestions() {
        ArrayList<Question> copy = new ArrayList<Question>(this.questions.size());
        copy.addAll(this.questions);
        return copy;
    }

    public List<Record<? extends Data>> copyAnswers() {
        ArrayList<Record<? extends Data>> res = new ArrayList<Record<? extends Data>>(this.answerSection.size());
        res.addAll(this.answerSection);
        return res;
    }

    public List<Record<? extends Data>> copyAuthority() {
        ArrayList<Record<? extends Data>> res = new ArrayList<Record<? extends Data>>(this.authoritySection.size());
        res.addAll(this.authoritySection);
        return res;
    }

    public EDNS getEdns() {
        if (this.edns != null) {
            return this.edns;
        }
        Record<OPT> optRecord = this.getOptPseudoRecord();
        if (optRecord == null) {
            return null;
        }
        this.edns = new EDNS(optRecord);
        return this.edns;
    }

    public Record<OPT> getOptPseudoRecord() {
        if (this.optRrPosition == -1) {
            return null;
        }
        return this.additionalSection.get(this.optRrPosition);
    }

    public boolean isDnssecOk() {
        EDNS edns = this.getEdns();
        if (edns == null) {
            return false;
        }
        return edns.dnssecOk;
    }

    public String toString() {
        if (this.toStringCache != null) {
            return this.toStringCache;
        }
        StringBuilder sb = new StringBuilder("DNSMessage").append('(').append(this.id).append(' ').append((Object)this.opcode).append(' ').append((Object)this.responseCode).append(' ');
        if (this.qr) {
            sb.append("resp[qr=1]");
        } else {
            sb.append("query[qr=0]");
        }
        if (this.authoritativeAnswer) {
            sb.append(" aa");
        }
        if (this.truncated) {
            sb.append(" tr");
        }
        if (this.recursionDesired) {
            sb.append(" rd");
        }
        if (this.recursionAvailable) {
            sb.append(" ra");
        }
        if (this.authenticData) {
            sb.append(" ad");
        }
        if (this.checkingDisabled) {
            sb.append(" cd");
        }
        sb.append(")\n");
        if (this.questions != null) {
            for (Question question : this.questions) {
                sb.append("[Q: ").append(question).append("]\n");
            }
        }
        if (this.answerSection != null) {
            for (Record record : this.answerSection) {
                sb.append("[A: ").append(record).append("]\n");
            }
        }
        if (this.authoritySection != null) {
            for (Record record : this.authoritySection) {
                sb.append("[N: ").append(record).append("]\n");
            }
        }
        if (this.additionalSection != null) {
            for (Record record : this.additionalSection) {
                sb.append("[X: ");
                EDNS edns = EDNS.fromRecord(record);
                if (edns != null) {
                    sb.append(edns.toString());
                } else {
                    sb.append(record);
                }
                sb.append("]\n");
            }
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        this.toStringCache = sb.toString();
        return this.toStringCache;
    }

    public String asTerminalOutput() {
        if (this.terminalOutputCache != null) {
            return this.terminalOutputCache;
        }
        StringBuilder sb = new StringBuilder(";; ->>HEADER<<-").append(" opcode: ").append((Object)this.opcode).append(", status: ").append((Object)this.responseCode).append(", id: ").append(this.id).append("\n").append(";; flags:");
        if (!this.qr) {
            sb.append(" qr");
        }
        if (this.authoritativeAnswer) {
            sb.append(" aa");
        }
        if (this.truncated) {
            sb.append(" tr");
        }
        if (this.recursionDesired) {
            sb.append(" rd");
        }
        if (this.recursionAvailable) {
            sb.append(" ra");
        }
        if (this.authenticData) {
            sb.append(" ad");
        }
        if (this.checkingDisabled) {
            sb.append(" cd");
        }
        sb.append("; QUERY: ").append(this.questions.size()).append(", ANSWER: ").append(this.answerSection.size()).append(", AUTHORITY: ").append(this.authoritySection.size()).append(", ADDITIONAL: ").append(this.additionalSection.size()).append("\n\n");
        for (Record<? extends Data> record : this.additionalSection) {
            EDNS edns = EDNS.fromRecord(record);
            if (edns == null) continue;
            sb.append(";; OPT PSEUDOSECTION:\n; ").append(edns.asTerminalOutput());
            break;
        }
        if (this.questions.size() != 0) {
            sb.append(";; QUESTION SECTION:\n");
            for (Question question : this.questions) {
                sb.append(';').append(question.toString()).append('\n');
            }
        }
        if (this.authoritySection.size() != 0) {
            sb.append("\n;; AUTHORITY SECTION:\n");
            for (Record record : this.authoritySection) {
                sb.append(record.toString()).append('\n');
            }
        }
        if (this.answerSection.size() != 0) {
            sb.append("\n;; ANSWER SECTION:\n");
            for (Record record : this.answerSection) {
                sb.append(record.toString()).append('\n');
            }
        }
        if (this.additionalSection.size() != 0) {
            boolean hasNonOptArr = false;
            for (Record<? extends Data> record : this.additionalSection) {
                if (record.type == Record.TYPE.OPT) continue;
                if (!hasNonOptArr) {
                    hasNonOptArr = true;
                    sb.append("\n;; ADDITIONAL SECTION:\n");
                }
                sb.append(record.toString()).append('\n');
            }
        }
        if (this.receiveTimestamp > 0L) {
            sb.append("\n;; WHEN: ").append(new Date(this.receiveTimestamp).toString());
        }
        this.terminalOutputCache = sb.toString();
        return this.terminalOutputCache;
    }

    public <D extends Data> Set<D> getAnswersFor(Question q) {
        if (this.responseCode != RESPONSE_CODE.NO_ERROR) {
            return null;
        }
        HashSet<Data> res = new HashSet<Data>(this.answerSection.size());
        for (Record<? extends Data> record : this.answerSection) {
            Data data;
            Data d;
            boolean isNew;
            if (!record.isAnswer(q) || (isNew = res.add(d = (data = record.getPayload())))) continue;
            LOGGER.log(Level.WARNING, "DNSMessage contains duplicate answers. Record: " + record + "; DNSMessage: " + this);
        }
        return res;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public DNSMessage asNormalizedVersion() {
        if (this.normalizedVersionCache == null) {
            this.normalizedVersionCache = new DNSMessage(this);
        }
        return this.normalizedVersionCache;
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            byte[] bytes = this.serialize();
            this.hashCodeCache = Arrays.hashCode(bytes);
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DNSMessage)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        DNSMessage otherDnsMessage = (DNSMessage)other;
        byte[] otherBytes = otherDnsMessage.serialize();
        byte[] myBytes = this.serialize();
        return Arrays.equals(myBytes, otherBytes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int id;
        private OPCODE opcode = OPCODE.QUERY;
        private RESPONSE_CODE responseCode = RESPONSE_CODE.NO_ERROR;
        private boolean query;
        private boolean authoritativeAnswer;
        private boolean truncated;
        private boolean recursionDesired;
        private boolean recursionAvailable;
        private boolean authenticData;
        private boolean checkingDisabled;
        private long receiveTimestamp = -1L;
        private List<Question> questions;
        private List<Record<? extends Data>> answers;
        private List<Record<? extends Data>> nameserverRecords;
        private List<Record<? extends Data>> additionalResourceRecords;
        private EDNS.Builder ednsBuilder;

        private Builder() {
        }

        private Builder(DNSMessage message) {
            this.id = message.id;
            this.opcode = message.opcode;
            this.responseCode = message.responseCode;
            this.query = message.qr;
            this.authoritativeAnswer = message.authoritativeAnswer;
            this.truncated = message.truncated;
            this.recursionDesired = message.recursionDesired;
            this.recursionAvailable = message.recursionAvailable;
            this.authenticData = message.authenticData;
            this.checkingDisabled = message.checkingDisabled;
            this.receiveTimestamp = message.receiveTimestamp;
            this.questions = new ArrayList<Question>(message.questions.size());
            this.questions.addAll(message.questions);
            this.answers = new ArrayList<Record<? extends Data>>(message.answerSection.size());
            this.answers.addAll(message.answerSection);
            this.nameserverRecords = new ArrayList<Record<? extends Data>>(message.authoritySection.size());
            this.nameserverRecords.addAll(message.authoritySection);
            this.additionalResourceRecords = new ArrayList<Record<? extends Data>>(message.additionalSection.size());
            this.additionalResourceRecords.addAll(message.additionalSection);
        }

        public Builder setId(int id) {
            this.id = id & 0xFFFF;
            return this;
        }

        public Builder setOpcode(OPCODE opcode) {
            this.opcode = opcode;
            return this;
        }

        public Builder setResponseCode(RESPONSE_CODE responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public Builder setQrFlag(boolean query) {
            this.query = query;
            return this;
        }

        public Builder setAuthoritativeAnswer(boolean authoritativeAnswer) {
            this.authoritativeAnswer = authoritativeAnswer;
            return this;
        }

        public Builder setTruncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public Builder setRecursionDesired(boolean recursionDesired) {
            this.recursionDesired = recursionDesired;
            return this;
        }

        public Builder setRecursionAvailable(boolean recursionAvailable) {
            this.recursionAvailable = recursionAvailable;
            return this;
        }

        public Builder setAuthenticData(boolean authenticData) {
            this.authenticData = authenticData;
            return this;
        }

        @Deprecated
        public Builder setCheckDisabled(boolean checkingDisabled) {
            this.checkingDisabled = checkingDisabled;
            return this;
        }

        public Builder setCheckingDisabled(boolean checkingDisabled) {
            this.checkingDisabled = checkingDisabled;
            return this;
        }

        public void copyFlagsFrom(DNSMessage dnsMessage) {
            this.query = dnsMessage.qr;
            this.authoritativeAnswer = dnsMessage.authenticData;
            this.truncated = dnsMessage.truncated;
            this.recursionDesired = dnsMessage.recursionDesired;
            this.recursionAvailable = dnsMessage.recursionAvailable;
            this.authenticData = dnsMessage.authenticData;
            this.checkingDisabled = dnsMessage.checkingDisabled;
        }

        public Builder setReceiveTimestamp(long receiveTimestamp) {
            this.receiveTimestamp = receiveTimestamp;
            return this;
        }

        public Builder addQuestion(Question question) {
            if (this.questions == null) {
                this.questions = new ArrayList<Question>(1);
            }
            this.questions.add(question);
            return this;
        }

        public Builder setQuestions(List<Question> questions) {
            this.questions = questions;
            return this;
        }

        public Builder setQuestion(Question question) {
            this.questions = new ArrayList<Question>(1);
            this.questions.add(question);
            return this;
        }

        public Builder addAnswer(Record<? extends Data> answer) {
            if (this.answers == null) {
                this.answers = new ArrayList<Record<? extends Data>>(1);
            }
            this.answers.add(answer);
            return this;
        }

        public Builder addAnswers(Collection<Record<? extends Data>> records) {
            if (this.answers == null) {
                this.answers = new ArrayList<Record<? extends Data>>(records.size());
            }
            this.answers.addAll(records);
            return this;
        }

        public Builder setAnswers(Collection<Record<? extends Data>> records) {
            this.answers = new ArrayList<Record<? extends Data>>(records.size());
            this.answers.addAll(records);
            return this;
        }

        public List<Record<? extends Data>> getAnswers() {
            if (this.answers == null) {
                return Collections.emptyList();
            }
            return this.answers;
        }

        public Builder addNameserverRecords(Record<? extends Data> record) {
            if (this.nameserverRecords == null) {
                this.nameserverRecords = new ArrayList<Record<? extends Data>>(8);
            }
            this.nameserverRecords.add(record);
            return this;
        }

        public Builder setNameserverRecords(Collection<Record<? extends Data>> records) {
            this.nameserverRecords = new ArrayList<Record<? extends Data>>(records.size());
            this.nameserverRecords.addAll(records);
            return this;
        }

        public Builder setAdditionalResourceRecords(Collection<Record<? extends Data>> records) {
            this.additionalResourceRecords = new ArrayList<Record<? extends Data>>(records.size());
            this.additionalResourceRecords.addAll(records);
            return this;
        }

        public Builder addAdditionalResourceRecord(Record<? extends Data> record) {
            if (this.additionalResourceRecords == null) {
                this.additionalResourceRecords = new ArrayList<Record<? extends Data>>();
            }
            this.additionalResourceRecords.add(record);
            return this;
        }

        public Builder addAdditionalResourceRecords(List<Record<? extends Data>> records) {
            if (this.additionalResourceRecords == null) {
                this.additionalResourceRecords = new ArrayList<Record<? extends Data>>(records.size());
            }
            this.additionalResourceRecords.addAll(records);
            return this;
        }

        public List<Record<? extends Data>> getAdditionalResourceRecords() {
            if (this.additionalResourceRecords == null) {
                return Collections.emptyList();
            }
            return this.additionalResourceRecords;
        }

        public EDNS.Builder getEdnsBuilder() {
            if (this.ednsBuilder == null) {
                this.ednsBuilder = EDNS.builder();
            }
            return this.ednsBuilder;
        }

        public DNSMessage build() {
            return new DNSMessage(this);
        }
    }

    public static enum OPCODE {
        QUERY,
        INVERSE_QUERY,
        STATUS,
        UNASSIGNED3,
        NOTIFY,
        UPDATE;

        private static final OPCODE[] INVERSE_LUT;
        private final byte value = (byte)this.ordinal();

        public byte getValue() {
            return this.value;
        }

        public static OPCODE getOpcode(int value) throws IllegalArgumentException {
            if (value < 0 || value > 15) {
                throw new IllegalArgumentException();
            }
            if (value >= INVERSE_LUT.length) {
                return null;
            }
            return INVERSE_LUT[value];
        }

        static {
            INVERSE_LUT = new OPCODE[OPCODE.values().length];
            for (OPCODE opcode : OPCODE.values()) {
                if (INVERSE_LUT[opcode.getValue()] != null) {
                    throw new IllegalStateException();
                }
                OPCODE.INVERSE_LUT[opcode.getValue()] = opcode;
            }
        }
    }

    public static enum RESPONSE_CODE {
        NO_ERROR(0),
        FORMAT_ERR(1),
        SERVER_FAIL(2),
        NX_DOMAIN(3),
        NO_IMP(4),
        REFUSED(5),
        YXDOMAIN(6),
        YXRRSET(7),
        NXRRSET(8),
        NOT_AUTH(9),
        NOT_ZONE(10),
        BADVERS_BADSIG(16),
        BADKEY(17),
        BADTIME(18),
        BADMODE(19),
        BADNAME(20),
        BADALG(21),
        BADTRUNC(22),
        BADCOOKIE(23);

        private static final Map<Integer, RESPONSE_CODE> INVERSE_LUT;
        private final byte value;

        private RESPONSE_CODE(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static RESPONSE_CODE getResponseCode(int value) throws IllegalArgumentException {
            if (value < 0 || value > 65535) {
                throw new IllegalArgumentException();
            }
            return INVERSE_LUT.get(value);
        }

        static {
            INVERSE_LUT = new HashMap<Integer, RESPONSE_CODE>(RESPONSE_CODE.values().length);
            for (RESPONSE_CODE responseCode : RESPONSE_CODE.values()) {
                INVERSE_LUT.put(Integer.valueOf(responseCode.value), responseCode);
            }
        }
    }
}

