/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.record.Data;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class InternetAddressRR
extends Data {
    protected final byte[] ip;
    private InetAddress inetAddress;

    protected InternetAddressRR(byte[] ip) {
        this.ip = ip;
    }

    @Override
    public final void serialize(DataOutputStream dos) throws IOException {
        dos.write(this.ip);
    }

    public final byte[] getIp() {
        return (byte[])this.ip.clone();
    }

    public final InetAddress getInetAddress() {
        InetAddress i = this.inetAddress;
        if (i == null) {
            try {
                i = InetAddress.getByAddress(this.ip);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
            this.inetAddress = i;
        }
        return i;
    }
}

