/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns;

public abstract class InvalidDNSNameException
extends IllegalStateException {
    private static final long serialVersionUID = 1L;
    protected final String name;

    protected InvalidDNSNameException(String name) {
        this.name = name;
    }

    public static class DNSNameTooLongException
    extends InvalidDNSNameException {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        public DNSNameTooLongException(String name, byte[] bytes) {
            super(name);
            this.bytes = bytes;
        }

        @Override
        public String getMessage() {
            return "The DNS name '" + this.name + "' exceeds the maximum name length of " + 255 + " octets by " + (this.bytes.length - 255) + " octets.";
        }
    }

    public static class LabelTooLongException
    extends InvalidDNSNameException {
        private static final long serialVersionUID = 1L;
        private final String label;

        public LabelTooLongException(String name, String label) {
            super(name);
            this.label = label;
        }

        @Override
        public String getMessage() {
            return "The DNS name '" + this.name + "' contains the label '" + this.label + "' which exceeds the maximum label length of " + 63 + " octets by " + (this.label.length() - 63) + " octets.";
        }
    }
}

