/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jxmpp.jid.Jid;

public abstract class XMPPException
extends Exception {
    private static final long serialVersionUID = 6881651633890968625L;

    protected XMPPException() {
    }

    protected XMPPException(String message) {
        super(message);
    }

    protected XMPPException(String message, Throwable wrappedThrowable) {
        super(message, wrappedThrowable);
    }

    public static class StreamErrorException
    extends XMPPException {
        private static final long serialVersionUID = 3400556867134848886L;
        private final StreamError streamError;

        public StreamErrorException(StreamError streamError) {
            super(streamError.getCondition().toString() + " You can read more about the meaning of this stream error at http://xmpp.org/rfcs/rfc6120.html#streams-error-conditions\n" + streamError.toString());
            this.streamError = streamError;
        }

        public StreamError getStreamError() {
            return this.streamError;
        }
    }

    public static class FailedNonzaException
    extends XMPPException {
        private static final long serialVersionUID = 1L;
        private final XMPPError.Condition condition;
        private final Nonza nonza;

        public FailedNonzaException(Nonza nonza, XMPPError.Condition condition) {
            this.condition = condition;
            this.nonza = nonza;
        }

        public XMPPError.Condition getCondition() {
            return this.condition;
        }

        public Nonza getNonza() {
            return this.nonza;
        }
    }

    public static class XMPPErrorException
    extends XMPPException {
        private static final long serialVersionUID = 212790389529249604L;
        private final XMPPError error;
        private final Stanza stanza;

        @Deprecated
        public XMPPErrorException(XMPPError.Builder xmppErrorBuilder) {
            this(null, xmppErrorBuilder.build());
        }

        public XMPPErrorException(Stanza stanza, XMPPError error) {
            this.error = error;
            this.stanza = stanza;
        }

        public XMPPError getXMPPError() {
            return this.error;
        }

        @Override
        public String getMessage() {
            Jid from;
            StringBuilder sb = new StringBuilder();
            if (this.stanza != null && (from = this.stanza.getFrom()) != null) {
                sb.append("XMPP error reply received from " + from + ": ");
            }
            sb.append(this.error);
            return sb.toString();
        }

        public static void ifHasErrorThenThrow(Stanza packet) throws XMPPErrorException {
            XMPPError xmppError = packet.getError();
            if (xmppError != null) {
                throw new XMPPErrorException(packet, xmppError);
            }
        }
    }
}

