/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.hla;

import de.measite.minidns.DNSMessage;
import de.measite.minidns.MiniDNSException;
import de.measite.minidns.Question;
import de.measite.minidns.dnssec.DNSSECResultNotAuthenticException;
import de.measite.minidns.dnssec.UnverifiedReason;
import de.measite.minidns.hla.ResolutionUnsuccessfulException;
import de.measite.minidns.record.Data;
import java.util.Collections;
import java.util.Set;

public class ResolverResult<D extends Data> {
    private final Question question;
    private final DNSMessage.RESPONSE_CODE responseCode;
    private final Set<D> data;
    private final boolean isAuthenticData;
    private final Set<UnverifiedReason> unverifiedReasons;
    private ResolutionUnsuccessfulException resolutionUnsuccessfulException;
    private DNSSECResultNotAuthenticException dnssecResultNotAuthenticException;

    ResolverResult(Question question, DNSMessage answer, Set<UnverifiedReason> unverifiedReasons) throws MiniDNSException.NullResultException {
        if (answer == null) {
            throw new MiniDNSException.NullResultException(question.asMessageBuilder().build());
        }
        this.question = question;
        this.responseCode = answer.responseCode;
        Set r = answer.getAnswersFor(question);
        this.data = r == null ? Collections.emptySet() : Collections.unmodifiableSet(r);
        if (unverifiedReasons == null) {
            this.unverifiedReasons = null;
            this.isAuthenticData = false;
        } else {
            this.unverifiedReasons = Collections.unmodifiableSet(unverifiedReasons);
            this.isAuthenticData = this.unverifiedReasons.isEmpty();
        }
    }

    public boolean wasSuccessful() {
        return this.responseCode == DNSMessage.RESPONSE_CODE.NO_ERROR;
    }

    public Set<D> getAnswers() {
        this.throwIseIfErrorResponse();
        return this.data;
    }

    public Set<D> getAnswersOrEmptySet() {
        return this.data;
    }

    public DNSMessage.RESPONSE_CODE getResponseCode() {
        return this.responseCode;
    }

    public boolean isAuthenticData() {
        this.throwIseIfErrorResponse();
        return this.isAuthenticData;
    }

    public Set<UnverifiedReason> getUnverifiedReasons() {
        this.throwIseIfErrorResponse();
        return this.unverifiedReasons;
    }

    public Question getQuestion() {
        return this.question;
    }

    public void throwIfErrorResponse() throws ResolutionUnsuccessfulException {
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = this.getResolutionUnsuccessfulException();
        if (resolutionUnsuccessfulException != null) {
            throw resolutionUnsuccessfulException;
        }
    }

    public ResolutionUnsuccessfulException getResolutionUnsuccessfulException() {
        if (this.wasSuccessful()) {
            return null;
        }
        if (this.resolutionUnsuccessfulException == null) {
            this.resolutionUnsuccessfulException = new ResolutionUnsuccessfulException(this.question, this.responseCode);
        }
        return this.resolutionUnsuccessfulException;
    }

    public DNSSECResultNotAuthenticException getDnssecResultNotAuthenticException() {
        if (!this.wasSuccessful()) {
            return null;
        }
        if (this.isAuthenticData) {
            return null;
        }
        if (this.dnssecResultNotAuthenticException == null) {
            this.dnssecResultNotAuthenticException = DNSSECResultNotAuthenticException.from(this.getUnverifiedReasons());
        }
        return this.dnssecResultNotAuthenticException;
    }

    private void throwIseIfErrorResponse() {
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = this.getResolutionUnsuccessfulException();
        if (resolutionUnsuccessfulException != null) {
            throw new IllegalStateException("Can not perform operation because the DNS resolution was unsuccessful", (Throwable)((Object)resolutionUnsuccessfulException));
        }
    }
}

