/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;

public class ReflectionDebuggerFactory
implements SmackDebuggerFactory {
    private static final Logger LOGGER = Logger.getLogger(ReflectionDebuggerFactory.class.getName());
    private static final String DEBUGGER_CLASS_PROPERTY_NAME = "smack.debuggerClass";
    private static final String[] DEFAULT_DEBUGGERS = new String[]{"org.jivesoftware.smackx.debugger.EnhancedDebugger", "org.jivesoftware.smackx.debugger.android.AndroidDebugger", "org.jivesoftware.smack.debugger.ConsoleDebugger", "org.jivesoftware.smack.debugger.LiteDebugger", "org.jivesoftware.smack.debugger.JulDebugger"};

    public static void setDebuggerClass(Class<? extends SmackDebugger> debuggerClass) {
        if (debuggerClass == null) {
            System.clearProperty(DEBUGGER_CLASS_PROPERTY_NAME);
        } else {
            System.setProperty(DEBUGGER_CLASS_PROPERTY_NAME, debuggerClass.getCanonicalName());
        }
    }

    public static Class<SmackDebugger> getDebuggerClass() {
        String customDebuggerClassName = ReflectionDebuggerFactory.getCustomDebuggerClassName();
        if (customDebuggerClassName == null) {
            return ReflectionDebuggerFactory.getOneOfDefaultDebuggerClasses();
        }
        try {
            return Class.forName(customDebuggerClassName);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to instantiate debugger class " + customDebuggerClassName, e);
            return null;
        }
    }

    @Override
    public SmackDebugger create(XMPPConnection connection, Writer writer, Reader reader) throws IllegalArgumentException {
        Class<SmackDebugger> debuggerClass = ReflectionDebuggerFactory.getDebuggerClass();
        if (debuggerClass != null) {
            try {
                Constructor<SmackDebugger> constructor = debuggerClass.getConstructor(XMPPConnection.class, Writer.class, Reader.class);
                return constructor.newInstance(connection, writer, reader);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't initialize the configured debugger!", e);
            }
        }
        return null;
    }

    private static String getCustomDebuggerClassName() {
        try {
            return System.getProperty(DEBUGGER_CLASS_PROPERTY_NAME);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Class<SmackDebugger> getOneOfDefaultDebuggerClasses() {
        for (String debugger : DEFAULT_DEBUGGERS) {
            if (SmackConfiguration.isDisabledSmackClass(debugger)) continue;
            try {
                return Class.forName(debugger);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.fine("Did not find debugger class '" + debugger + "'");
            }
            catch (ClassCastException ex) {
                LOGGER.warning("Found debugger class that does not appears to implement SmackDebugger interface");
            }
            catch (Exception ex) {
                LOGGER.warning("Unable to instantiate either Smack debugger class");
            }
        }
        return null;
    }
}

