/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class StreamOpen
implements Nonza {
    public static final String ELEMENT = "stream:stream";
    public static final String CLIENT_NAMESPACE = "jabber:client";
    public static final String SERVER_NAMESPACE = "jabber:server";
    public static final String VERSION = "1.0";
    private final String from;
    private final String to;
    private final String id;
    private final String lang;
    private final String contentNamespace;

    public StreamOpen(CharSequence to) {
        this(to, null, null, null, StreamContentNamespace.client);
    }

    public StreamOpen(CharSequence to, CharSequence from, String id) {
        this(to, from, id, "en", StreamContentNamespace.client);
    }

    public StreamOpen(CharSequence to, CharSequence from, String id, String lang, StreamContentNamespace ns) {
        this.to = StringUtils.maybeToString(to);
        this.from = StringUtils.maybeToString(from);
        this.id = id;
        this.lang = lang;
        switch (ns) {
            case client: {
                this.contentNamespace = CLIENT_NAMESPACE;
                break;
            }
            case server: {
                this.contentNamespace = SERVER_NAMESPACE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public String getNamespace() {
        return this.contentNamespace;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.attribute("to", this.to);
        xml.attribute("xmlns:stream", "http://etherx.jabber.org/streams");
        xml.attribute("version", VERSION);
        xml.optAttribute("from", this.from);
        xml.optAttribute("id", this.id);
        xml.xmllangAttribute(this.lang);
        xml.rightAngleBracket();
        return xml;
    }

    public static enum StreamContentNamespace {
        client,
        server;

    }
}

