/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dnssec.algorithms;

import de.measite.minidns.DNSSECConstants;
import de.measite.minidns.dnssec.DNSSECValidatorInitializationException;
import de.measite.minidns.dnssec.DigestCalculator;
import de.measite.minidns.dnssec.SignatureVerifier;
import de.measite.minidns.dnssec.algorithms.DSASignatureVerifier;
import de.measite.minidns.dnssec.algorithms.ECDSASignatureVerifier;
import de.measite.minidns.dnssec.algorithms.ECGOSTSignatureVerifier;
import de.measite.minidns.dnssec.algorithms.JavaSecDigestCalculator;
import de.measite.minidns.dnssec.algorithms.RSASignatureVerifier;
import de.measite.minidns.record.NSEC3;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlgorithmMap {
    private Logger LOGGER = Logger.getLogger(AlgorithmMap.class.getName());
    public static final AlgorithmMap INSTANCE = new AlgorithmMap();
    private final Map<DNSSECConstants.DigestAlgorithm, DigestCalculator> dsDigestMap = new HashMap<DNSSECConstants.DigestAlgorithm, DigestCalculator>();
    private final Map<DNSSECConstants.SignatureAlgorithm, SignatureVerifier> signatureMap = new HashMap<DNSSECConstants.SignatureAlgorithm, SignatureVerifier>();
    private final Map<NSEC3.HashAlgorithm, DigestCalculator> nsecDigestMap = new HashMap<NSEC3.HashAlgorithm, DigestCalculator>();

    private AlgorithmMap() {
        try {
            this.dsDigestMap.put(DNSSECConstants.DigestAlgorithm.SHA1, new JavaSecDigestCalculator("SHA-1"));
            this.nsecDigestMap.put(NSEC3.HashAlgorithm.SHA1, new JavaSecDigestCalculator("SHA-1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new DNSSECValidatorInitializationException("SHA-1 is mandatory", e);
        }
        try {
            this.dsDigestMap.put(DNSSECConstants.DigestAlgorithm.SHA256, new JavaSecDigestCalculator("SHA-256"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new DNSSECValidatorInitializationException("SHA-256 is mandatory", e);
        }
        try {
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.RSAMD5, new RSASignatureVerifier("MD5withRSA"));
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.FINER, "Platform does not support RSA/MD5", e);
        }
        try {
            DSASignatureVerifier sha1withDSA = new DSASignatureVerifier("SHA1withDSA");
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.DSA, sha1withDSA);
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.DSA_NSEC3_SHA1, sha1withDSA);
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.FINE, "Platform does not support DSA/SHA-1", e);
        }
        try {
            RSASignatureVerifier sha1withRSA = new RSASignatureVerifier("SHA1withRSA");
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.RSASHA1, sha1withRSA);
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.RSASHA1_NSEC3_SHA1, sha1withRSA);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DNSSECValidatorInitializationException("Platform does not support RSA/SHA-1", e);
        }
        try {
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.RSASHA256, new RSASignatureVerifier("SHA256withRSA"));
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support RSA/SHA-256", e);
        }
        try {
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.RSASHA512, new RSASignatureVerifier("SHA512withRSA"));
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support RSA/SHA-512", e);
        }
        try {
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.ECC_GOST, new ECGOSTSignatureVerifier());
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.FINE, "Platform does not support GOST R 34.10-2001", e);
        }
        try {
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.ECDSAP256SHA256, new ECDSASignatureVerifier.P256SHA256());
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support ECDSA/SHA-256", e);
        }
        try {
            this.signatureMap.put(DNSSECConstants.SignatureAlgorithm.ECDSAP384SHA384, new ECDSASignatureVerifier.P384SHA284());
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support ECDSA/SHA-384", e);
        }
    }

    public DigestCalculator getDsDigestCalculator(DNSSECConstants.DigestAlgorithm algorithm) {
        return this.dsDigestMap.get(algorithm);
    }

    public SignatureVerifier getSignatureVerifier(DNSSECConstants.SignatureAlgorithm algorithm) {
        return this.signatureMap.get(algorithm);
    }

    public DigestCalculator getNsecDigestCalculator(NSEC3.HashAlgorithm algorithm) {
        return this.nsecDigestMap.get(algorithm);
    }
}

