/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dane;

import de.measite.minidns.AbstractDNSClient;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.DNSName;
import de.measite.minidns.Record;
import de.measite.minidns.dane.DaneCertificateException;
import de.measite.minidns.dane.ExpectingTrustManager;
import de.measite.minidns.dnssec.DNSSECClient;
import de.measite.minidns.dnssec.DNSSECMessage;
import de.measite.minidns.dnssec.UnverifiedReason;
import de.measite.minidns.record.TLSA;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;

public class DaneVerifier {
    private static final Logger LOGGER = Logger.getLogger(DaneVerifier.class.getName());
    private final AbstractDNSClient client;

    public DaneVerifier() {
        this((AbstractDNSClient)new DNSSECClient());
    }

    public DaneVerifier(AbstractDNSClient client) {
        this.client = client;
    }

    public boolean verify(SSLSocket socket) throws CertificateException {
        if (!socket.isConnected()) {
            throw new IllegalStateException("Socket not yet connected.");
        }
        return this.verify(socket.getSession());
    }

    public boolean verify(SSLSession session) throws CertificateException {
        try {
            return this.verifyCertificateChain(DaneVerifier.convert(session.getPeerCertificateChain()), session.getPeerHost(), session.getPeerPort());
        }
        catch (SSLPeerUnverifiedException e) {
            throw new CertificateException("Peer not verified", e);
        }
    }

    public boolean verifyCertificateChain(java.security.cert.X509Certificate[] chain, String hostName, int port) throws CertificateException {
        DNSMessage res;
        DNSName req = DNSName.from((String)("_" + port + "._tcp." + hostName));
        try {
            res = this.client.query(req, Record.TYPE.TLSA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!res.authenticData) {
            String msg = "Got TLSA response from DNS server, but was not signed properly.";
            if (res instanceof DNSSECMessage) {
                msg = msg + " Reasons:";
                for (UnverifiedReason reason : ((DNSSECMessage)res).getUnverifiedReasons()) {
                    msg = msg + " " + reason;
                }
            }
            LOGGER.info(msg);
            return false;
        }
        LinkedList<DaneCertificateException.CertificateMismatch> certificateMismatchExceptions = new LinkedList<DaneCertificateException.CertificateMismatch>();
        boolean verified = false;
        for (Record record : res.answerSection) {
            if (record.type != Record.TYPE.TLSA || !record.name.equals((Object)req)) continue;
            TLSA tlsa = (TLSA)record.payloadData;
            try {
                verified |= DaneVerifier.checkCertificateMatches(chain[0], tlsa, hostName);
            }
            catch (DaneCertificateException.CertificateMismatch certificateMismatchException) {
                certificateMismatchExceptions.add(certificateMismatchException);
            }
            if (!verified) continue;
            break;
        }
        if (!verified && !certificateMismatchExceptions.isEmpty()) {
            throw new DaneCertificateException.MultipleCertificateMismatchExceptions(certificateMismatchExceptions);
        }
        return verified;
    }

    private static boolean checkCertificateMatches(java.security.cert.X509Certificate cert, TLSA tlsa, String hostName) throws CertificateException {
        switch (tlsa.certUsage) {
            case 1: 
            case 3: {
                break;
            }
            default: {
                LOGGER.warning("TLSA certificate usage " + tlsa.certUsage + " not supported while verifying " + hostName);
                return false;
            }
        }
        byte[] comp = null;
        switch (tlsa.selector) {
            case 0: {
                comp = cert.getEncoded();
                break;
            }
            case 1: {
                comp = cert.getPublicKey().getEncoded();
                break;
            }
            default: {
                LOGGER.warning("TLSA selector " + tlsa.selector + " not supported while verifying " + hostName);
                return false;
            }
        }
        switch (tlsa.matchingType) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    comp = MessageDigest.getInstance("SHA-256").digest(comp);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CertificateException("Verification using TLSA failed: could not SHA-256 for matching", e);
                }
            }
            case 2: {
                try {
                    comp = MessageDigest.getInstance("SHA-512").digest(comp);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CertificateException("Verification using TLSA failed: could not SHA-512 for matching", e);
                }
            }
            default: {
                LOGGER.warning("TLSA matching type " + tlsa.matchingType + " not supported while verifying " + hostName);
                return false;
            }
        }
        boolean matches = tlsa.certificateAssociationEquals(comp);
        if (!matches) {
            throw new DaneCertificateException.CertificateMismatch(tlsa, comp);
        }
        return tlsa.certUsage == 3;
    }

    public HttpsURLConnection verifiedConnect(HttpsURLConnection conn) throws IOException, CertificateException {
        return this.verifiedConnect(conn, null);
    }

    public HttpsURLConnection verifiedConnect(HttpsURLConnection conn, X509TrustManager trustManager) throws IOException, CertificateException {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            ExpectingTrustManager expectingTrustManager = new ExpectingTrustManager(trustManager);
            context.init(null, new TrustManager[]{expectingTrustManager}, null);
            conn.setSSLSocketFactory(context.getSocketFactory());
            conn.connect();
            boolean fullyVerified = this.verifyCertificateChain(DaneVerifier.convert(conn.getServerCertificates()), conn.getURL().getHost(), conn.getURL().getPort() < 0 ? conn.getURL().getDefaultPort() : conn.getURL().getPort());
            if (!fullyVerified && expectingTrustManager.hasException()) {
                throw new IOException("Peer verification failed using PKIX", expectingTrustManager.getException());
            }
            return conn;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static java.security.cert.X509Certificate[] convert(Certificate[] certificates) {
        ArrayList<java.security.cert.X509Certificate> certs = new ArrayList<java.security.cert.X509Certificate>();
        for (Certificate certificate : certificates) {
            if (!(certificate instanceof java.security.cert.X509Certificate)) continue;
            certs.add((java.security.cert.X509Certificate)certificate);
        }
        return certs.toArray(new java.security.cert.X509Certificate[certs.size()]);
    }

    private static java.security.cert.X509Certificate[] convert(X509Certificate[] certificates) {
        java.security.cert.X509Certificate[] certs = new java.security.cert.X509Certificate[certificates.length];
        for (int i = 0; i < certificates.length; ++i) {
            try {
                certs[i] = (java.security.cert.X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificates[i].getEncoded()));
                continue;
            }
            catch (CertificateException | CertificateEncodingException e) {
                LOGGER.log(Level.WARNING, "Could not convert", e);
            }
        }
        return certs;
    }
}

