/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import org.jivesoftware.smack.proxy.HTTPProxySocketConnection;
import org.jivesoftware.smack.proxy.ProxySocketConnection;
import org.jivesoftware.smack.proxy.Socks4ProxySocketConnection;
import org.jivesoftware.smack.proxy.Socks5ProxySocketConnection;

public class ProxyInfo {
    private String proxyAddress;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private ProxyType proxyType;
    private final ProxySocketConnection proxySocketConnection;

    public ProxyInfo(ProxyType pType, String pHost, int pPort, String pUser, String pPass) {
        this.proxyType = pType;
        this.proxyAddress = pHost;
        this.proxyPort = pPort;
        this.proxyUsername = pUser;
        this.proxyPassword = pPass;
        switch (this.proxyType) {
            case HTTP: {
                this.proxySocketConnection = new HTTPProxySocketConnection(this);
                break;
            }
            case SOCKS4: {
                this.proxySocketConnection = new Socks4ProxySocketConnection(this);
                break;
            }
            case SOCKS5: {
                this.proxySocketConnection = new Socks5ProxySocketConnection(this);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static ProxyInfo forHttpProxy(String pHost, int pPort, String pUser, String pPass) {
        return new ProxyInfo(ProxyType.HTTP, pHost, pPort, pUser, pPass);
    }

    public static ProxyInfo forSocks4Proxy(String pHost, int pPort, String pUser, String pPass) {
        return new ProxyInfo(ProxyType.SOCKS4, pHost, pPort, pUser, pPass);
    }

    public static ProxyInfo forSocks5Proxy(String pHost, int pPort, String pUser, String pPass) {
        return new ProxyInfo(ProxyType.SOCKS5, pHost, pPort, pUser, pPass);
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public ProxySocketConnection getProxySocketConnection() {
        return this.proxySocketConnection;
    }

    public static enum ProxyType {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

