/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns;

import de.measite.minidns.DNSCache;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.DNSName;
import de.measite.minidns.Question;
import de.measite.minidns.Record;
import de.measite.minidns.cache.LRUCache;
import de.measite.minidns.record.A;
import de.measite.minidns.record.AAAA;
import de.measite.minidns.record.Data;
import de.measite.minidns.record.InternetAddressRR;
import de.measite.minidns.record.NS;
import de.measite.minidns.source.DNSDataSource;
import de.measite.minidns.source.NetworkDataSource;
import java.io.IOException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDNSClient {
    protected static final LRUCache DEFAULT_CACHE = new LRUCache(1024);
    protected static final Logger LOGGER = Logger.getLogger(AbstractDNSClient.class.getName());
    protected final Random random;
    protected final Random insecureRandom = new Random();
    protected final DNSCache cache;
    protected DNSDataSource dataSource = new NetworkDataSource();
    protected static IpVersionSetting ipVersionSetting = IpVersionSetting.v4v6;

    public static void setPreferedIpVersion(IpVersionSetting preferedIpVersion) {
        if (preferedIpVersion == null) {
            throw new IllegalArgumentException();
        }
        ipVersionSetting = preferedIpVersion;
    }

    protected AbstractDNSClient(DNSCache cache) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e1) {
            random = new SecureRandom();
        }
        this.random = random;
        this.cache = cache;
    }

    protected AbstractDNSClient() {
        this(DEFAULT_CACHE);
    }

    public final DNSMessage query(String name, Record.TYPE type, Record.CLASS clazz) throws IOException {
        Question q = new Question(name, type, clazz);
        return this.query(q);
    }

    public final DNSMessage query(DNSName name, Record.TYPE type) throws IOException {
        Question q = new Question(name, type, Record.CLASS.IN);
        return this.query(q);
    }

    public final DNSMessage query(CharSequence name, Record.TYPE type) throws IOException {
        Question q = new Question(name, type, Record.CLASS.IN);
        return this.query(q);
    }

    public DNSMessage query(Question q) throws IOException {
        DNSMessage.Builder query = this.buildMessage(q);
        return this.query(query);
    }

    protected abstract DNSMessage query(DNSMessage.Builder var1) throws IOException;

    public final DNSMessage query(Question q, InetAddress server, int port) throws IOException {
        DNSMessage query = this.getQueryFor(q);
        return this.query(query, server, port);
    }

    public final DNSMessage query(DNSMessage requestMessage, InetAddress address, int port) throws IOException {
        DNSMessage responseMessage;
        DNSMessage dNSMessage = responseMessage = this.cache == null ? null : this.cache.get(requestMessage);
        if (responseMessage != null) {
            return responseMessage;
        }
        Question q = requestMessage.getQuestion();
        Level TRACE_LOG_LEVEL = Level.FINE;
        LOGGER.log(TRACE_LOG_LEVEL, "Asking {0} on {1} for {2} with:\n{3}", new Object[]{address, port, q, requestMessage});
        try {
            responseMessage = this.dataSource.query(requestMessage, address, port);
        }
        catch (IOException e) {
            LOGGER.log(TRACE_LOG_LEVEL, "IOException {0} on {1} while resolving {2}: {3}", new Object[]{address, port, q, e});
            throw e;
        }
        if (responseMessage != null) {
            LOGGER.log(TRACE_LOG_LEVEL, "Response from {0} on {1} for {2}:\n{3}", new Object[]{address, port, q, responseMessage});
        } else {
            LOGGER.log(Level.SEVERE, "NULL response from " + address + " on " + port + " for " + q);
        }
        if (responseMessage == null) {
            return null;
        }
        if (this.cache != null && this.isResponseCacheable(q, responseMessage)) {
            this.cache.put(requestMessage.asNormalizedVersion(), responseMessage);
        }
        return responseMessage;
    }

    protected boolean isResponseCacheable(Question q, DNSMessage dnsMessage) {
        for (Record<? extends Data> record : dnsMessage.answerSection) {
            if (!record.isAnswer(q)) continue;
            return true;
        }
        return false;
    }

    final DNSMessage.Builder buildMessage(Question question) {
        DNSMessage.Builder message = DNSMessage.builder();
        message.setQuestion(question);
        message.setId(this.random.nextInt());
        message = this.newQuestion(message);
        return message;
    }

    protected abstract DNSMessage.Builder newQuestion(DNSMessage.Builder var1);

    public DNSMessage query(String name, Record.TYPE type, Record.CLASS clazz, InetAddress address, int port) throws IOException {
        Question q = new Question(name, type, clazz);
        return this.query(q, address, port);
    }

    public DNSMessage query(String name, Record.TYPE type, Record.CLASS clazz, InetAddress address) throws IOException {
        Question q = new Question(name, type, clazz);
        return this.query(q, address);
    }

    public final DNSMessage query(DNSMessage query, InetAddress host) throws IOException {
        return this.query(query, host, 53);
    }

    public DNSMessage query(Question q, InetAddress address) throws IOException {
        return this.query(q, address, 53);
    }

    public DNSDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DNSDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException();
        }
        this.dataSource = dataSource;
    }

    public DNSCache getCache() {
        return this.cache;
    }

    protected DNSMessage getQueryFor(Question q) {
        DNSMessage.Builder messageBuilder = this.buildMessage(q);
        DNSMessage query = messageBuilder.build();
        return query;
    }

    private <D extends Data> Set<D> getCachedRecordsFor(DNSName dnsName, Record.TYPE type) {
        Question dnsNameNs = new Question(dnsName, type);
        DNSMessage queryDnsNameNs = this.getQueryFor(dnsNameNs);
        DNSMessage cachedResult = this.cache.get(queryDnsNameNs);
        if (cachedResult == null) {
            return Collections.emptySet();
        }
        return cachedResult.getAnswersFor(dnsNameNs);
    }

    public Set<NS> getCachedNameserverRecordsFor(DNSName dnsName) {
        return this.getCachedRecordsFor(dnsName, Record.TYPE.NS);
    }

    public Set<A> getCachedIPv4AddressesFor(DNSName dnsName) {
        return this.getCachedRecordsFor(dnsName, Record.TYPE.A);
    }

    public Set<AAAA> getCachedIPv6AddressesFor(DNSName dnsName) {
        return this.getCachedRecordsFor(dnsName, Record.TYPE.AAAA);
    }

    private <D extends Data> Set<D> getCachedIPNameserverAddressesFor(DNSName dnsName, Record.TYPE type) {
        Set<NS> nsSet = this.getCachedNameserverRecordsFor(dnsName);
        if (nsSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<A> res = new HashSet<A>(3 * nsSet.size());
        for (NS ns : nsSet) {
            Set<InternetAddressRR> addresses;
            switch (type) {
                case A: {
                    addresses = this.getCachedIPv4AddressesFor(ns.name);
                    break;
                }
                case AAAA: {
                    addresses = this.getCachedIPv6AddressesFor(ns.name);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            res.addAll(addresses);
        }
        return res;
    }

    public Set<A> getCachedIPv4NameserverAddressesFor(DNSName dnsName) {
        return this.getCachedIPNameserverAddressesFor(dnsName, Record.TYPE.A);
    }

    public Set<AAAA> getCachedIPv6NameserverAddressesFor(DNSName dnsName) {
        return this.getCachedIPNameserverAddressesFor(dnsName, Record.TYPE.AAAA);
    }

    public static enum IpVersionSetting {
        v4only,
        v6only,
        v4v6,
        v6v4;

    }
}

