/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.DNSName;
import de.measite.minidns.Record;
import de.measite.minidns.record.Data;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MX
extends Data {
    public final int priority;
    public final DNSName name;

    public static MX parse(DataInputStream dis, byte[] data) throws IOException {
        int priority = dis.readUnsignedShort();
        DNSName name = DNSName.parse(dis, data);
        return new MX(priority, name);
    }

    public MX(int priority, String name) {
        this(priority, DNSName.from(name));
    }

    public MX(int priority, DNSName name) {
        this.priority = priority;
        this.name = name;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeShort(this.priority);
        this.name.writeToStream(dos);
    }

    public String toString() {
        return this.priority + " " + this.name + '.';
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.MX;
    }
}

