/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class BoBData {
    private final int maxAge;
    private final String type;
    private byte[] contentBinary;
    private String contentString;

    public BoBData(String type, byte[] content) {
        this(type, content, -1);
    }

    public BoBData(String type, byte[] content, int maxAge) {
        this.type = type;
        this.contentBinary = content;
        this.maxAge = maxAge;
    }

    public BoBData(String type, String content) {
        this(type, content, -1);
    }

    public BoBData(String type, String content, int maxAge) {
        this.type = type;
        this.contentString = content;
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getType() {
        return this.type;
    }

    private void setContentBinaryIfRequired() {
        if (this.contentBinary == null) {
            assert (StringUtils.isNotEmpty((CharSequence)this.contentString));
            this.contentBinary = Base64.decode((String)this.contentString);
        }
    }

    public byte[] getContent() {
        this.setContentBinaryIfRequired();
        return (byte[])this.contentBinary.clone();
    }

    public String getContentBase64Encoded() {
        if (this.contentString == null) {
            this.contentString = Base64.encodeToString((byte[])this.getContent());
        }
        return this.contentString;
    }

    public boolean isOfReasonableSize() {
        this.setContentBinaryIfRequired();
        return this.contentBinary.length <= 8192;
    }
}

