/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.iterative;

import de.measite.minidns.AbstractDNSClient;
import de.measite.minidns.DNSCache;
import de.measite.minidns.DNSClient;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.Question;
import de.measite.minidns.iterative.IterativeDNSClient;
import de.measite.minidns.source.DNSDataSource;
import de.measite.minidns.util.MultipleIoException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;

public class ReliableDNSClient
extends AbstractDNSClient {
    private final IterativeDNSClient recursiveDnsClient;
    private final DNSClient dnsClient;
    private Mode mode = Mode.recursiveWithIterativeFallback;

    public ReliableDNSClient(DNSCache dnsCache) {
        super(dnsCache);
        this.recursiveDnsClient = new IterativeDNSClient(dnsCache){

            @Override
            protected DNSMessage.Builder newQuestion(DNSMessage.Builder questionMessage) {
                questionMessage = super.newQuestion(questionMessage);
                return ReliableDNSClient.this.newQuestion(questionMessage);
            }

            @Override
            protected boolean isResponseCacheable(Question q, DNSMessage dnsMessage) {
                boolean res = super.isResponseCacheable(q, dnsMessage);
                return ReliableDNSClient.this.isResponseCacheable(q, dnsMessage) && res;
            }
        };
        this.dnsClient = new DNSClient(dnsCache){

            protected DNSMessage.Builder newQuestion(DNSMessage.Builder questionMessage) {
                questionMessage = super.newQuestion(questionMessage);
                return ReliableDNSClient.this.newQuestion(questionMessage);
            }

            protected boolean isResponseCacheable(Question q, DNSMessage dnsMessage) {
                boolean res = super.isResponseCacheable(q, dnsMessage);
                return ReliableDNSClient.this.isResponseCacheable(q, dnsMessage) && res;
            }
        };
    }

    public ReliableDNSClient() {
        this((DNSCache)DEFAULT_CACHE);
    }

    protected DNSMessage query(DNSMessage.Builder q) throws IOException {
        DNSMessage dnsMessage = null;
        String unacceptableReason = null;
        LinkedList<IOException> ioExceptions = new LinkedList<IOException>();
        if (this.mode != Mode.iterativeOnly) {
            try {
                dnsMessage = this.dnsClient.query(q);
                if (dnsMessage != null && (unacceptableReason = this.isResponseAcceptable(dnsMessage)) == null) {
                    return dnsMessage;
                }
            }
            catch (IOException ioException) {
                ioExceptions.add(ioException);
            }
        }
        if (this.mode == Mode.recursiveOnly) {
            return dnsMessage;
        }
        Level FALLBACK_LOG_LEVEL = Level.FINE;
        if (LOGGER.isLoggable(FALLBACK_LOG_LEVEL) && this.mode != Mode.iterativeOnly) {
            String logString = "Resolution fall back to iterative mode because: ";
            if (!ioExceptions.isEmpty()) {
                logString = logString + ioExceptions.get(0);
            } else if (dnsMessage == null) {
                logString = logString + " DNSClient did not return a response";
            } else if (unacceptableReason != null) {
                logString = logString + unacceptableReason + ". Response:\n" + dnsMessage;
            } else {
                throw new AssertionError((Object)"This should never been reached");
            }
            LOGGER.log(FALLBACK_LOG_LEVEL, logString);
        }
        try {
            dnsMessage = this.recursiveDnsClient.query(q);
        }
        catch (IOException ioException) {
            ioExceptions.add(ioException);
        }
        if (dnsMessage == null) {
            MultipleIoException.throwIfRequired(ioExceptions);
        }
        return dnsMessage;
    }

    protected DNSMessage.Builder newQuestion(DNSMessage.Builder questionMessage) {
        return questionMessage;
    }

    protected boolean isResponseCacheable(Question q, DNSMessage dnsMessage) {
        return this.isResponseAcceptable(dnsMessage) == null;
    }

    protected String isResponseAcceptable(DNSMessage response) {
        return null;
    }

    public void setDataSource(DNSDataSource dataSource) {
        super.setDataSource(dataSource);
        this.recursiveDnsClient.setDataSource(dataSource);
        this.dnsClient.setDataSource(dataSource);
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must not be null.");
        }
        this.mode = mode;
    }

    public static enum Mode {
        recursiveWithIterativeFallback,
        recursiveOnly,
        iterativeOnly;

    }
}

