/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dnssec.algorithms;

import de.measite.minidns.dnssec.DNSSECValidationFailedException;
import de.measite.minidns.dnssec.algorithms.JavaSecSignatureVerifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

class DSASignatureVerifier
extends JavaSecSignatureVerifier {
    private static final int LENGTH = 20;

    public DSASignatureVerifier(String algorithm) throws NoSuchAlgorithmException {
        super("DSA", algorithm);
    }

    @Override
    protected byte[] getSignature(byte[] rrsigData) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(rrsigData));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte t = dis.readByte();
            byte[] r = new byte[20];
            dis.readFully(r);
            int rlen = r[0] < 0 ? 21 : 20;
            byte[] s = new byte[20];
            dis.readFully(s);
            int slen = s[0] < 0 ? 21 : 20;
            dos.writeByte(48);
            dos.writeByte(rlen + slen + 4);
            dos.writeByte(2);
            dos.writeByte(rlen);
            if (rlen > 20) {
                dos.writeByte(0);
            }
            dos.write(r);
            dos.writeByte(2);
            dos.writeByte(slen);
            if (slen > 20) {
                dos.writeByte(0);
            }
            dos.write(s);
        }
        catch (IOException e) {
            throw new DNSSECValidationFailedException("Invalid signature!", e);
        }
        return bos.toByteArray();
    }

    @Override
    protected PublicKey getPublicKey(byte[] key) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(key));
        try {
            int t = dis.readUnsignedByte();
            byte[] subPrimeBytes = new byte[20];
            dis.readFully(subPrimeBytes);
            BigInteger subPrime = new BigInteger(1, subPrimeBytes);
            byte[] primeBytes = new byte[64 + t * 8];
            dis.readFully(primeBytes);
            BigInteger prime = new BigInteger(1, primeBytes);
            byte[] baseBytes = new byte[64 + t * 8];
            dis.readFully(baseBytes);
            BigInteger base = new BigInteger(1, baseBytes);
            byte[] pubKeyBytes = new byte[64 + t * 8];
            dis.readFully(pubKeyBytes);
            BigInteger pubKey = new BigInteger(1, pubKeyBytes);
            return this.getKeyFactory().generatePublic(new DSAPublicKeySpec(pubKey, prime, subPrime, base));
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new DNSSECValidationFailedException("Invalid public key!", e);
        }
    }
}

