/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.hla;

import de.measite.minidns.AbstractDNSClient;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.DNSName;
import de.measite.minidns.Question;
import de.measite.minidns.Record;
import de.measite.minidns.hla.ResolverResult;
import de.measite.minidns.iterative.ReliableDNSClient;
import de.measite.minidns.record.Data;
import java.io.IOException;

public class ResolverApi {
    public static final ResolverApi INSTANCE = new ResolverApi((AbstractDNSClient)new ReliableDNSClient());
    private final AbstractDNSClient dnsClient;

    public ResolverApi(AbstractDNSClient dnsClient) {
        this.dnsClient = dnsClient;
    }

    public final <D extends Data> ResolverResult<D> resolve(String name, Class<D> type) throws IOException {
        return this.resolve(DNSName.from((String)name), type);
    }

    public final <D extends Data> ResolverResult<D> resolve(DNSName name, Class<D> type) throws IOException {
        Record.TYPE t = Record.TYPE.getType(type);
        Question q = new Question(name, t);
        return this.resolve(q);
    }

    public <D extends Data> ResolverResult<D> resolve(Question question) throws IOException {
        DNSMessage dnsMessage = this.dnsClient.query(question);
        return new ResolverResult(question, dnsMessage, null);
    }

    public final AbstractDNSClient getClient() {
        return this.dnsClient;
    }
}

