/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.source;

import de.measite.minidns.DNSMessage;
import de.measite.minidns.MiniDNSException;
import de.measite.minidns.source.DNSDataSource;
import de.measite.minidns.util.MultipleIoException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkDataSource
extends DNSDataSource {
    protected static final Logger LOGGER = Logger.getLogger(NetworkDataSource.class.getName());

    @Override
    public DNSMessage query(DNSMessage message, InetAddress address, int port) throws IOException {
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>(2);
        DNSMessage dnsMessage = null;
        try {
            dnsMessage = this.queryUdp(message, address, port);
        }
        catch (IOException e) {
            ioExceptions.add(e);
        }
        if (dnsMessage != null && !dnsMessage.truncated) {
            return dnsMessage;
        }
        assert (dnsMessage == null || dnsMessage.truncated || ioExceptions.size() == 1);
        LOGGER.log(Level.FINE, "Fallback to TCP because {0}", new Object[]{dnsMessage != null ? "response is truncated" : (Serializable)ioExceptions.get(0)});
        try {
            dnsMessage = this.queryTcp(message, address, port);
        }
        catch (IOException e) {
            ioExceptions.add(e);
            MultipleIoException.throwIfRequired(ioExceptions);
        }
        return dnsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DNSMessage queryUdp(DNSMessage message, InetAddress address, int port) throws IOException {
        DatagramSocket socket = null;
        DatagramPacket packet = message.asDatagram(address, port);
        byte[] buffer = new byte[this.udpPayloadSize];
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(this.timeout);
            socket.send(packet);
            packet = new DatagramPacket(buffer, buffer.length);
            socket.receive(packet);
            DNSMessage dnsMessage = new DNSMessage(packet.getData());
            if (dnsMessage.id != message.id) {
                throw new MiniDNSException.IdMismatch(message, dnsMessage);
            }
            DNSMessage dNSMessage = dnsMessage;
            return dNSMessage;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DNSMessage queryTcp(DNSMessage message, InetAddress address, int port) throws IOException {
        try (Socket socket = null;){
            socket = new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(address, port);
            socket.connect(socketAddress, this.timeout);
            socket.setSoTimeout(this.timeout);
            DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
            message.writeTo(dos);
            dos.flush();
            DataInputStream dis = new DataInputStream(socket.getInputStream());
            int length = dis.readUnsignedShort();
            byte[] data = new byte[length];
            for (int read = 0; read < length; read += dis.read(data, read, length - read)) {
            }
            DNSMessage dnsMessage = new DNSMessage(data);
            if (dnsMessage.id != message.id) {
                throw new MiniDNSException.IdMismatch(message, dnsMessage);
            }
            DNSMessage dNSMessage = dnsMessage;
            return dNSMessage;
        }
    }
}

