/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.provider;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VCardProvider
extends IQProvider<VCard> {
    private static final String[] ADR = new String[]{"POSTAL", "PARCEL", "DOM", "INTL", "PREF", "POBOX", "EXTADR", "STREET", "LOCALITY", "REGION", "PCODE", "CTRY", "FF"};
    private static final String[] TEL = new String[]{"VOICE", "FAX", "PAGER", "MSG", "CELL", "VIDEO", "BBS", "MODEM", "ISDN", "PCS", "PREF"};

    /*
     * Enabled aggressive block sorting
     */
    public VCard parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        VCard vCard = new VCard();
        String name = null;
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    switch (name = parser.getName()) {
                        case "N": {
                            VCardProvider.parseName(parser, vCard);
                            break block0;
                        }
                        case "ORG": {
                            VCardProvider.parseOrg(parser, vCard);
                            break block0;
                        }
                        case "TEL": {
                            VCardProvider.parseTel(parser, vCard);
                            break block0;
                        }
                        case "ADR": {
                            VCardProvider.parseAddress(parser, vCard);
                            break block0;
                        }
                        case "EMAIL": {
                            VCardProvider.parseEmail(parser, vCard);
                            break block0;
                        }
                        case "NICKNAME": {
                            vCard.setNickName(parser.nextText());
                            break block0;
                        }
                        case "JABBERID": {
                            vCard.setJabberId(parser.nextText());
                            break block0;
                        }
                        case "PHOTO": {
                            VCardProvider.parsePhoto(parser, vCard);
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    if (initialDepth + 1 != parser.getDepth()) break;
                    vCard.setField(name, parser.getText());
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return vCard;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseAddress(XmlPullParser parser, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        boolean isWork = true;
        while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("HOME".equals(name)) {
                        isWork = false;
                        break;
                    }
                    for (String adr : ADR) {
                        if (!adr.equals(name)) continue;
                        if (isWork) {
                            vCard.setAddressFieldWork(name, parser.nextText());
                            continue;
                        }
                        vCard.setAddressFieldHome(name, parser.nextText());
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseTel(XmlPullParser parser, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        boolean isWork = true;
        String telLabel = null;
        while (true) {
            int eventType = parser.next();
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("HOME".equals(name)) {
                        isWork = false;
                        break;
                    }
                    if ("NUMBER".equals(name)) {
                        if (StringUtils.isNullOrEmpty(telLabel)) {
                            telLabel = "VOICE";
                        }
                        if (isWork) {
                            vCard.setPhoneWork(telLabel, parser.nextText());
                            break;
                        }
                        vCard.setPhoneHome(telLabel, parser.nextText());
                        break;
                    }
                    for (String tel : TEL) {
                        if (!tel.equals(name)) continue;
                        telLabel = name;
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseOrg(XmlPullParser parser, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "ORGNAME": {
                            vCard.setOrganization(parser.nextText());
                            break block0;
                        }
                        case "ORGUNIT": {
                            vCard.setOrganizationUnit(parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseEmail(XmlPullParser parser, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        boolean isWork = false;
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "WORK": {
                            isWork = true;
                            break block0;
                        }
                        case "USERID": {
                            if (isWork) {
                                vCard.setEmailWork(parser.nextText());
                                break block0;
                            }
                            vCard.setEmailHome(parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseName(XmlPullParser parser, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "FAMILY": {
                            vCard.setLastName(parser.nextText());
                            break block0;
                        }
                        case "GIVEN": {
                            vCard.setFirstName(parser.nextText());
                            break block0;
                        }
                        case "MIDDLE": {
                            vCard.setMiddleName(parser.nextText());
                            break block0;
                        }
                        case "PREFIX": {
                            vCard.setPrefix(parser.nextText());
                            break block0;
                        }
                        case "SUFFIX": {
                            vCard.setSuffix(parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parsePhoto(XmlPullParser parser, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        String binval = null;
        String mimetype = null;
        block12: while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "BINVAL": {
                            binval = parser.nextText();
                            break block0;
                        }
                        case "TYPE": {
                            mimetype = parser.nextText();
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block12;
                }
            }
        }
        if (binval != null && mimetype != null) {
            vCard.setAvatar(binval, mimetype);
            return;
        }
    }
}

