/*
	l12_integer_tables.h: Layer1/2 Constant tables for integer decoders

	copyright 1995-2009 by the mpg123 project - free software under the terms of the LGPL 2.1
	see COPYING and AUTHORS files in distribution or http://mpg123.org
	initially written by Taihei Monma
*/

#ifndef MPG123_L12_INTEGER_TABLES_H
#define MPG123_L12_INTEGER_TABLES_H

static const real layer12_table[27][64] =
{
	{ /* C90 does not like empty initializer. Fill with junk. */
		1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
	, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38
	, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56
	, 57, 58, 59, 60, 61, 62, 63, 64
	},
	{
		-1431655765,-1136305934,-901886617,-715827883,-568152967,-450943309,-357913941,-284076483,
		-225471654,-178956971,-142038242,-112735827,-89478485,-71019121,-56367914,-44739243,
		-35509560,-28183957,-22369621,-17754780,-14091978,-11184811,-8877390,-7045989,
		-5592405,-4438695,-3522995,-2796203,-2219348,-1761497,-1398101,-1109674,
		-880749,-699051,-554837,-440374,-349525,-277418,-220187,-174763,
		-138709,-110094,-87381,-69355,-55047,-43691,-34677,-27523,
		-21845,-17339,-13762,-10923,-8669,-6881,-5461,-4335,
		-3440,-2731,-2167,-1720,-1365,-1084,-860,0
	},
	{
		1431655765,1136305934,901886617,715827883,568152967,450943309,357913941,284076483,
		225471654,178956971,142038242,112735827,89478485,71019121,56367914,44739243,
		35509560,28183957,22369621,17754780,14091978,11184811,8877390,7045989,
		5592405,4438695,3522995,2796203,2219348,1761497,1398101,1109674,
		880749,699051,554837,440374,349525,277418,220187,174763,
		138709,110094,87381,69355,55047,43691,34677,27523,
		21845,17339,13762,10923,8669,6881,5461,4335,
		3440,2731,2167,1720,1365,1084,860,0
	},
	{
		613566757,486988257,386522836,306783378,243494129,193261418,153391689,121747064,
		96630709,76695845,60873532,48315355,38347922,30436766,24157677,19173961,
		15218383,12078839,9586981,7609192,6039419,4793490,3804596,3019710,
		2396745,1902298,1509855,1198373,951149,754927,599186,475574,
		377464,299593,237787,188732,149797,118894,94366,74898,
		59447,47183,37449,29723,23591,18725,14862,11796,
		9362,7431,5898,4681,3715,2949,2341,1858,
		1474,1170,929,737,585,464,369,0
	},
	{
		286331153,227261187,180377323,143165577,113630593,90188662,71582788,56815297,
		45094331,35791394,28407648,22547165,17895697,14203824,11273583,8947849,
		7101912,5636791,4473924,3550956,2818396,2236962,1775478,1409198,
		1118481,887739,704599,559241,443870,352299,279620,221935,
		176150,139810,110967,88075,69905,55484,44037,34953,
		27742,22019,17476,13871,11009,8738,6935,5505,
		4369,3468,2752,2185,1734,1376,1092,867,
		688,546,433,344,273,217,172,0
	},
	{
		138547332,109965090,87279350,69273666,54982545,43639675,34636833,27491273,
		21819838,17318417,13745636,10909919,8659208,6872818,5454959,4329604,
		3436409,2727480,2164802,1718205,1363740,1082401,859102,681870,
		541201,429551,340935,270600,214776,170467,135300,107388,
		85234,67650,53694,42617,33825,26847,21308,16913,
		13423,10654,8456,6712,5327,4228,3356,2664,
		2114,1678,1332,1057,839,666,529,419,
		333,264,210,166,132,105,83,0
	},
	{
		68174084,54109806,42946982,34087042,27054903,21473491,17043521,13527452,
		10736745,8521761,6763726,5368373,4260880,3381863,2684186,2130440,
		1690931,1342093,1065220,845466,671047,532610,422733,335523,
		266305,211366,167762,133153,105683,83881,66576,52842,
		41940,33288,26421,20970,16644,13210,10485,8322,
		6605,5243,4161,3303,2621,2081,1651,1311,
		1040,826,655,520,413,328,260,206,
		164,130,103,82,65,52,41,0
	},
	{
		33818640,26841872,21304408,16909320,13420936,10652204,8454660,6710468,
		5326102,4227330,3355234,2663051,2113665,1677617,1331526,1056833,
		838809,665763,528416,419404,332881,264208,209702,166441,
		132104,104851,83220,66052,52426,41610,33026,26213,
		20805,16513,13106,10403,8257,6553,5201,4128,
		3277,2601,2064,1638,1300,1032,819,650,
		516,410,325,258,205,163,129,102,
		81,65,51,41,32,26,20,0
	},
	{
		16843009,13368305,10610431,8421505,6684153,5305215,4210752,3342076,
		2652608,2105376,1671038,1326304,1052688,835519,663152,526344,
		417760,331576,263172,208880,165788,131586,104440,82894,
		65793,52220,41447,32897,26110,20723,16448,13055,
		10362,8224,6527,5181,4112,3264,2590,2056,
		1632,1295,1028,816,648,514,408,324,
		257,204,162,129,102,81,64,51,
		40,32,25,20,16,13,10,0
	},
	{
		8405024,6671072,5294833,4202512,3335536,2647417,2101256,1667768,
		1323708,1050628,833884,661854,525314,416942,330927,262657,
		208471,165464,131329,104236,82732,65664,52118,41366,
		32832,26059,20683,16416,13029,10341,8208,6515,
		5171,4104,3257,2585,2052,1629,1293,1026,
		814,646,513,407,323,257,204,162,
		128,102,81,64,51,40,32,25,
		20,16,13,10,8,6,5,0
	},
	{
		4198404,3332275,2644829,2099202,1666138,1322414,1049601,833069,
		661207,524801,416534,330604,262400,208267,165302,131200,
		104134,82651,65600,52067,41325,32800,26033,20663,
		16400,13017,10331,8200,6508,5166,4100,3254,
		2583,2050,1627,1291,1025,814,646,513,
		407,323,256,203,161,128,102,81,
		64,51,40,32,25,20,16,13,
		10,8,6,5,4,3,3,0
	},
	{
		2098177,1665324,1321768,1049088,832662,660884,524544,416331,
		330442,262272,208165,165221,131136,104083,82611,65568,
		52041,41305,32784,26021,20653,16392,13010,10326,
		8196,6505,5163,4098,3253,2582,2049,1626,
		1291,1025,813,645,512,407,323,256,
		203,161,128,102,81,64,51,40,
		32,25,20,16,13,10,8,6,
		5,4,3,3,2,2,1,0
	},
	{
		1048832,832459,660723,524416,416229,330361,262208,208115,
		165181,131104,104057,82590,65552,52029,41295,32776,
		26014,20648,16388,13007,10324,8194,6504,5162,
		4097,3252,2581,2049,1626,1290,1024,813,
		645,512,406,323,256,203,161,128,
		102,81,64,51,40,32,25,20,
		16,13,10,8,6,5,4,3,
		3,2,2,1,1,1,1,0
	},
	{
		524352,416178,330321,262176,208089,165161,131088,104045,
		82580,65544,52022,41290,32772,26011,20645,16386,
		13006,10323,8193,6503,5161,4097,3251,2581,
		2048,1626,1290,1024,813,645,512,406,
		323,256,203,161,128,102,81,64,
		51,40,32,25,20,16,13,10,
		8,6,5,4,3,3,2,2,
		1,1,1,1,1,0,0,0
	},
	{
		262160,208077,165150,131080,104038,82575,65540,52019,
		41288,32770,26010,20644,16385,13005,10322,8193,
		6502,5161,4096,3251,2580,2048,1626,1290,
		1024,813,645,512,406,323,256,203,
		161,128,102,81,64,51,40,32,
		25,20,16,13,10,8,6,5,
		4,3,3,2,2,1,1,1,
		1,1,0,0,0,0,0,0
	},
	{
		131076,104035,82573,65538,52018,41286,32769,26009,
		20643,16385,13004,10322,8192,6502,5161,4096,
		3251,2580,2048,1626,1290,1024,813,645,
		512,406,323,256,203,161,128,102,
		81,64,51,40,32,25,20,16,
		13,10,8,6,5,4,3,3,
		2,2,1,1,1,1,1,0,
		0,0,0,0,0,0,0,0
	},
	{
		65537,52017,41286,32769,26008,20643,16384,13004,
		10321,8192,6502,5161,4096,3251,2580,2048,
		1626,1290,1024,813,645,512,406,323,
		256,203,161,128,102,81,64,51,
		40,32,25,20,16,13,10,8,
		6,5,4,3,3,2,2,1,
		1,1,1,1,0,0,0,0,
		0,0,0,0,0,0,0,0
	},
	{
		-1717986918,-1363567121,-1082263941,-858993459,-681783560,-541131970,-429496730,-340891780,
		-270565985,-214748365,-170445890,-135282993,-107374182,-85222945,-67641496,-53687091,
		-42611473,-33820748,-26843546,-21305736,-16910374,-13421773,-10652868,-8455187,
		-6710886,-5326434,-4227594,-3355443,-2663217,-2113797,-1677722,-1331609,
		-1056898,-838861,-665804,-528449,-419430,-332902,-264225,-209715,
		-166451,-132112,-104858,-83226,-66056,-52429,-41613,-33028,
		-26214,-20806,-16514,-13107,-10403,-8257,-6554,-5202,
		-4129,-3277,-2601,-2064,-1638,-1300,-1032,0
	},
	{
		-858993459,-681783560,-541131970,-429496730,-340891780,-270565985,-214748365,-170445890,
		-135282993,-107374182,-85222945,-67641496,-53687091,-42611473,-33820748,-26843546,
		-21305736,-16910374,-13421773,-10652868,-8455187,-6710886,-5326434,-4227594,
		-3355443,-2663217,-2113797,-1677722,-1331609,-1056898,-838861,-665804,
		-528449,-419430,-332902,-264225,-209715,-166451,-132112,-104858,
		-83226,-66056,-52429,-41613,-33028,-26214,-20806,-16514,
		-13107,-10403,-8257,-6554,-5202,-4129,-3277,-2601,
		-2064,-1638,-1300,-1032,-819,-650,-516,0
	},
	{
		858993459,681783560,541131970,429496730,340891780,270565985,214748365,170445890,
		135282993,107374182,85222945,67641496,53687091,42611473,33820748,26843546,
		21305736,16910374,13421773,10652868,8455187,6710886,5326434,4227594,
		3355443,2663217,2113797,1677722,1331609,1056898,838861,665804,
		528449,419430,332902,264225,209715,166451,132112,104858,
		83226,66056,52429,41613,33028,26214,20806,16514,
		13107,10403,8257,6554,5202,4129,3277,2601,
		2064,1638,1300,1032,819,650,516,0
	},
	{
		1717986918,1363567121,1082263941,858993459,681783560,541131970,429496730,340891780,
		270565985,214748365,170445890,135282993,107374182,85222945,67641496,53687091,
		42611473,33820748,26843546,21305736,16910374,13421773,10652868,8455187,
		6710886,5326434,4227594,3355443,2663217,2113797,1677722,1331609,
		1056898,838861,665804,528449,419430,332902,264225,209715,
		166451,132112,104858,83226,66056,52429,41613,33028,
		26214,20806,16514,13107,10403,8257,6554,5202,
		4129,3277,2601,2064,1638,1300,1032,0
	},
	{
		-1908874354,-1515074579,-1202515490,-954437177,-757537289,-601257745,-477218588,-378768645,
		-300628872,-238609294,-189384322,-150314436,-119304647,-94692161,-75157218,-59652324,
		-47346081,-37578609,-29826162,-23673040,-18789305,-14913081,-11836520,-9394652,
		-7456540,-5918260,-4697326,-3728270,-2959130,-2348663,-1864135,-1479565,
		-1174332,-932068,-739783,-587166,-466034,-369891,-293583,-233017,
		-184946,-146791,-116508,-92473,-73396,-58254,-46236,-36698,
		-29127,-23118,-18349,-14564,-11559,-9174,-7282,-5780,
		-4587,-3641,-2890,-2294,-1820,-1445,-1147,0
	},
	{
		-954437177,-757537289,-601257745,-477218588,-378768645,-300628872,-238609294,-189384322,
		-150314436,-119304647,-94692161,-75157218,-59652324,-47346081,-37578609,-29826162,
		-23673040,-18789305,-14913081,-11836520,-9394652,-7456540,-5918260,-4697326,
		-3728270,-2959130,-2348663,-1864135,-1479565,-1174332,-932068,-739783,
		-587166,-466034,-369891,-293583,-233017,-184946,-146791,-116508,
		-92473,-73396,-58254,-46236,-36698,-29127,-23118,-18349,
		-14564,-11559,-9174,-7282,-5780,-4587,-3641,-2890,
		-2294,-1820,-1445,-1147,-910,-722,-573,0
	},
	{
		-477218588,-378768645,-300628872,-238609294,-189384322,-150314436,-119304647,-94692161,
		-75157218,-59652324,-47346081,-37578609,-29826162,-23673040,-18789305,-14913081,
		-11836520,-9394652,-7456540,-5918260,-4697326,-3728270,-2959130,-2348663,
		-1864135,-1479565,-1174332,-932068,-739783,-587166,-466034,-369891,
		-293583,-233017,-184946,-146791,-116508,-92473,-73396,-58254,
		-46236,-36698,-29127,-23118,-18349,-14564,-11559,-9174,
		-7282,-5780,-4587,-3641,-2890,-2294,-1820,-1445,
		-1147,-910,-722,-573,-455,-361,-287,0
	},
	{
		477218588,378768645,300628872,238609294,189384322,150314436,119304647,94692161,
		75157218,59652324,47346081,37578609,29826162,23673040,18789305,14913081,
		11836520,9394652,7456540,5918260,4697326,3728270,2959130,2348663,
		1864135,1479565,1174332,932068,739783,587166,466034,369891,
		293583,233017,184946,146791,116508,92473,73396,58254,
		46236,36698,29127,23118,18349,14564,11559,9174,
		7282,5780,4587,3641,2890,2294,1820,1445,
		1147,910,722,573,455,361,287,0
	},
	{
		954437177,757537289,601257745,477218588,378768645,300628872,238609294,189384322,
		150314436,119304647,94692161,75157218,59652324,47346081,37578609,29826162,
		23673040,18789305,14913081,11836520,9394652,7456540,5918260,4697326,
		3728270,2959130,2348663,1864135,1479565,1174332,932068,739783,
		587166,466034,369891,293583,233017,184946,146791,116508,
		92473,73396,58254,46236,36698,29127,23118,18349,
		14564,11559,9174,7282,5780,4587,3641,2890,
		2294,1820,1445,1147,910,722,573,0
	},
	{
		1908874354,1515074579,1202515490,954437177,757537289,601257745,477218588,378768645,
		300628872,238609294,189384322,150314436,119304647,94692161,75157218,59652324,
		47346081,37578609,29826162,23673040,18789305,14913081,11836520,9394652,
		7456540,5918260,4697326,3728270,2959130,2348663,1864135,1479565,
		1174332,932068,739783,587166,466034,369891,293583,233017,
		184946,146791,116508,92473,73396,58254,46236,36698,
		29127,23118,18349,14564,11559,9174,7282,5780,
		4587,3641,2890,2294,1820,1445,1147,0
	},
};

#endif
