/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;

public abstract class AbstractListFilter
implements StanzaFilter {
    protected final List<StanzaFilter> filters;

    protected AbstractListFilter() {
        this.filters = new ArrayList<StanzaFilter>();
    }

    protected AbstractListFilter(StanzaFilter ... filters) {
        Objects.requireNonNull(filters, "Parameter must not be null.");
        for (StanzaFilter filter : filters) {
            Objects.requireNonNull(filter, "Parameter must not be null.");
        }
        this.filters = new ArrayList<StanzaFilter>(Arrays.asList(filters));
    }

    public void addFilter(StanzaFilter filter) {
        Objects.requireNonNull(filter, "Parameter must not be null.");
        this.filters.add(filter);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(": (");
        sb.append((CharSequence)StringUtils.toStringBuilder(this.filters, ", "));
        sb.append(')');
        return sb.toString();
    }
}

