/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.export.external;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.tencent.smtt.export.external.DexClassLoaderProviderService;
import com.tencent.smtt.export.external.DexLoader;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DexClassLoaderProvider
extends DexClassLoader {
    private static final String LOGTAG = "dexloader";
    private static final String LAST_DEX_NAME = "tbs_jars_fusion_dex.jar";
    private static final long LOAD_DEX_DELAY = 3000L;
    private static final String IS_FIRST_LOAD_DEX_FLAG_FILE = "is_first_load_dex_flag_file";
    private SpeedyDexClassLoader mClassLoader = null;
    protected static DexClassLoader mClassLoaderOriginal = null;
    private static DexClassLoaderProvider mInstance = null;
    private static String mRealDexPath = null;
    private static boolean mForceLoadDexFlag = false;
    protected static Service mService = null;
    private static Context mContext = null;

    private DexClassLoaderProvider(String string, String string2, String string3, ClassLoader classLoader, boolean bl2) {
        super(string, string2, string3, classLoader);
        if (bl2) {
            Log.e((String)LOGTAG, (String)("SpeedyDexClassLoader: " + mRealDexPath));
            this.mClassLoader = new SpeedyDexClassLoader(mRealDexPath, null, string3, classLoader);
        } else {
            Log.e((String)LOGTAG, (String)("DexClassLoader: " + mRealDexPath));
            this.mClassLoader = null;
        }
    }

    public static DexClassLoader createDexClassLoader(String string, String string2, String string3, ClassLoader classLoader, Context context) {
        mContext = context.getApplicationContext();
        mRealDexPath = string;
        int n2 = string.lastIndexOf("/");
        String string4 = string.substring(0, n2 + 1);
        string4 = string4 + "fake_dex.jar";
        String string5 = string.substring(n2 + 1);
        if (DexClassLoaderProvider.supportSpeedyClassLoader() && DexClassLoaderProvider.is_first_load_tbs_dex(string2, string5)) {
            DexClassLoaderProvider.set_first_load_tbs_dex(string2, string5);
            mInstance = new DexClassLoaderProvider(string4, string2, string3, classLoader, true);
            DexClassLoaderProvider.doAsyncDexLoad(string5, string, string2, string3, classLoader);
        } else {
            mInstance = new DexClassLoaderProvider(string, string2, string3, classLoader, false);
        }
        return mInstance;
    }

    private static boolean supportSpeedyClassLoader() {
        return Build.VERSION.SDK_INT != 21 || DexLoader.mCanUseDexLoaderProviderService;
    }

    private static boolean shouldUseDexLoaderService() {
        if (mForceLoadDexFlag) {
            return false;
        }
        return DexLoader.mCanUseDexLoaderProviderService;
    }

    private static void doAsyncDexLoad(final String string, final String string2, final String string3, final String string4, final ClassLoader classLoader) {
        if (DexClassLoaderProvider.shouldUseDexLoaderService()) {
            new Timer().schedule(new TimerTask(){

                public void run() {
                    try {
                        ArrayList<String> arrayList = new ArrayList<String>(4);
                        arrayList.add(0, string);
                        arrayList.add(1, string2);
                        arrayList.add(2, string3);
                        arrayList.add(3, string4);
                        Intent intent = new Intent(mContext, DexClassLoaderProviderService.class);
                        intent.putStringArrayListExtra("dex2oat", arrayList);
                        mContext.startService(intent);
                    }
                    catch (SecurityException securityException) {
                        Log.e((String)DexClassLoaderProvider.LOGTAG, (String)"start DexLoaderService exception", (Throwable)securityException);
                    }
                    catch (Throwable throwable) {
                        Log.e((String)DexClassLoaderProvider.LOGTAG, (String)("after shouldUseDexLoaderService exception: " + throwable));
                    }
                }
            }, 3000L);
            return;
        }
        new Timer().schedule(new TimerTask(){

            public void run() {
                try {
                    boolean bl2 = false;
                    String string5 = string2.replace(".jar", ".dex");
                    File file = new File(string5);
                    bl2 = file.exists() && file.length() != 0L;
                    File file2 = new File(string3);
                    File file3 = new File(string2);
                    boolean bl3 = file2.exists();
                    boolean bl4 = file2.isDirectory();
                    boolean bl5 = file3.exists();
                    if (!(bl3 && bl4 && bl5)) {
                        Log.d((String)DexClassLoaderProvider.LOGTAG, (String)("dex loading exception(" + bl3 + ", " + bl4 + ", " + bl5 + ")"));
                        return;
                    }
                    long l2 = System.currentTimeMillis();
                    DexClassLoader dexClassLoader = new DexClassLoader(string2, string3, string4, classLoader);
                    long l3 = System.currentTimeMillis() - l2;
                    String string22 = String.format("load_dex completed -- cl_cost: %d, existed: %b", l3, bl2);
                    if (mForceLoadDexFlag && DexClassLoaderProvider.LAST_DEX_NAME.equals(string) && mService != null) {
                        mService.stopSelf();
                    }
                }
                catch (Throwable throwable) {
                    Log.e((String)DexClassLoaderProvider.LOGTAG, (String)("@AsyncDexLoad task exception: " + throwable));
                }
            }
        }, 3000L);
    }

    private static boolean is_first_load_tbs_dex(String string, String string2) {
        if (mForceLoadDexFlag) {
            return true;
        }
        String string3 = string2 + "_" + IS_FIRST_LOAD_DEX_FLAG_FILE;
        File file = new File(string, string3);
        return !file.exists();
    }

    private static void set_first_load_tbs_dex(String string, String string2) {
        String string3 = string2 + "_" + IS_FIRST_LOAD_DEX_FLAG_FILE;
        File file = new File(string, string3);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected Class<?> findClass(String string) {
        if (this.useSelfClassloader()) {
            return super.findClass(string);
        }
        return this.mClassLoader.findClass(string);
    }

    public String findLibrary(String string) {
        if (this.useSelfClassloader()) {
            return super.findLibrary(string);
        }
        return this.mClassLoader.findLibrary(string);
    }

    protected URL findResource(String string) {
        if (this.useSelfClassloader()) {
            return super.findResource(string);
        }
        return this.mClassLoader.findResource(string);
    }

    protected Enumeration<URL> findResources(String string) {
        if (this.useSelfClassloader()) {
            return super.findResources(string);
        }
        return this.mClassLoader.findResources(string);
    }

    protected synchronized Package getPackage(String string) {
        if (this.useSelfClassloader()) {
            return super.getPackage(string);
        }
        return this.mClassLoader.getPackage(string);
    }

    public String toString() {
        if (this.useSelfClassloader()) {
            return super.toString();
        }
        return this.mClassLoader.toString();
    }

    public void clearAssertionStatus() {
        if (this.useSelfClassloader()) {
            super.clearAssertionStatus();
        } else {
            this.mClassLoader.clearAssertionStatus();
        }
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        if (this.useSelfClassloader()) {
            return super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
        }
        return this.mClassLoader.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
    }

    protected Package[] getPackages() {
        if (this.useSelfClassloader()) {
            return super.getPackages();
        }
        return this.mClassLoader.getPackages();
    }

    public URL getResource(String string) {
        if (this.useSelfClassloader()) {
            return super.getResource(string);
        }
        return this.mClassLoader.getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        if (this.useSelfClassloader()) {
            return this.getResourceAsStream(string);
        }
        return this.mClassLoader.getResourceAsStream(string);
    }

    public Enumeration<URL> getResources(String string) {
        if (this.useSelfClassloader()) {
            return super.getResources(string);
        }
        return this.mClassLoader.getResources(string);
    }

    protected Class<?> loadClass(String string, boolean bl2) {
        if (this.useSelfClassloader()) {
            return super.loadClass(string, bl2);
        }
        return this.mClassLoader.loadClass(string, bl2);
    }

    public Class<?> loadClass(String string) {
        if (this.useSelfClassloader()) {
            return super.loadClass(string);
        }
        return this.mClassLoader.loadClass(string);
    }

    private boolean useSelfClassloader() {
        return this.mClassLoader == null;
    }

    public void setClassAssertionStatus(String string, boolean bl2) {
        if (this.useSelfClassloader()) {
            super.setClassAssertionStatus(string, bl2);
        } else {
            this.mClassLoader.setClassAssertionStatus(string, bl2);
        }
    }

    public void setDefaultAssertionStatus(boolean bl2) {
        if (this.useSelfClassloader()) {
            super.setDefaultAssertionStatus(bl2);
        } else {
            this.mClassLoader.setDefaultAssertionStatus(bl2);
        }
    }

    public void setPackageAssertionStatus(String string, boolean bl2) {
        if (this.useSelfClassloader()) {
            super.setPackageAssertionStatus(string, bl2);
        } else {
            this.mClassLoader.setPackageAssertionStatus(string, bl2);
        }
    }

    static void setForceLoadDexFlag(boolean bl2, Service service) {
        mForceLoadDexFlag = bl2;
        mService = service;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpeedyDexClassLoader
    extends BaseDexClassLoader {
        public SpeedyDexClassLoader(String string, File file, String string2, ClassLoader classLoader) {
            super(string, null, string2, classLoader);
        }

        public Class<?> findClass(String string) {
            return super.findClass(string);
        }

        public URL findResource(String string) {
            return super.findResource(string);
        }

        public Enumeration<URL> findResources(String string) {
            return super.findResources(string);
        }

        public synchronized Package getPackage(String string) {
            return super.getPackage(string);
        }

        public Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
            return super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
        }

        public Package[] getPackages() {
            return super.getPackages();
        }

        public Class<?> loadClass(String string, boolean bl2) {
            return super.loadClass(string, bl2);
        }
    }
}

