/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BoundedThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Semaphore semaphore;

    public BoundedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int bound, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new ArrayBlockingQueue<Runnable>(bound), threadFactory);
        this.semaphore = new Semaphore(bound);
    }

    public void executeBlocking(final Runnable command) throws InterruptedException {
        this.semaphore.acquire();
        try {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        command.run();
                    }
                    finally {
                        BoundedThreadPoolExecutor.this.semaphore.release();
                    }
                }
            });
        }
        catch (Exception e) {
            this.semaphore.release();
            if (e instanceof RejectedExecutionException) {
                throw (RejectedExecutionException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

