/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Async {
    public static Thread go(Runnable runnable) {
        Thread thread = Async.daemonThreadFrom(runnable);
        thread.start();
        return thread;
    }

    public static Thread go(Runnable runnable, String threadName) {
        Thread thread = Async.daemonThreadFrom(runnable);
        thread.setName(threadName);
        thread.start();
        return thread;
    }

    public static Thread daemonThreadFrom(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    }

    public static abstract class ThrowingRunnable
    implements Runnable {
        public static final Logger LOGGER = Logger.getLogger(ThrowingRunnable.class.getName());

        @Override
        public final void run() {
            try {
                this.runOrThrow();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOGGER.log(Level.WARNING, "Catched Exception", e);
            }
        }

        public abstract void runOrThrow() throws Exception;
    }
}

