/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.ExpirationCache;

public final class ServiceDiscoveryManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ServiceDiscoveryManager.class.getName());
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private EntityCapsManager capsManager;
    private static Map<XMPPConnection, ServiceDiscoveryManager> instances = new WeakHashMap<XMPPConnection, ServiceDiscoveryManager>();
    private final Set<String> features = new HashSet<String>();
    private DataForm extendedInfo = null;
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();
    private Cache<String, List<DiscoverInfo>> services = new ExpirationCache(25, 86400000L);

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection connection) {
        super(connection);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#items", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverItems discoverItems = (DiscoverItems)iqRequest;
                DiscoverItems response = new DiscoverItems();
                response.setType(IQ.Type.result);
                response.setTo(discoverItems.getFrom());
                response.setStanzaId(discoverItems.getStanzaId());
                response.setNode(discoverItems.getNode());
                NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                if (nodeInformationProvider != null) {
                    response.addItems(nodeInformationProvider.getNodeItems());
                    response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                } else if (discoverItems.getNode() != null) {
                    response.setType(IQ.Type.error);
                    response.setError(XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.item_not_found));
                }
                return response;
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#info", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverInfo discoverInfo = (DiscoverInfo)iqRequest;
                DiscoverInfo response = new DiscoverInfo();
                response.setType(IQ.Type.result);
                response.setTo(discoverInfo.getFrom());
                response.setStanzaId(discoverInfo.getStanzaId());
                response.setNode(discoverInfo.getNode());
                if (discoverInfo.getNode() == null) {
                    ServiceDiscoveryManager.this.addDiscoverInfoTo(response);
                } else {
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                    if (nodeInformationProvider != null) {
                        response.addFeatures(nodeInformationProvider.getNodeFeatures());
                        response.addIdentities(nodeInformationProvider.getNodeIdentities());
                        response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                    } else {
                        response.setType(IQ.Type.error);
                        response.setError(XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.item_not_found));
                    }
                }
                return response;
            }
        });
    }

    public String getIdentityName() {
        return this.identity.getName();
    }

    public synchronized void setIdentity(DiscoverInfo.Identity identity) {
        this.identity = (DiscoverInfo.Identity)Objects.requireNonNull((Object)identity, (String)"Identity can not be null");
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identity.getType();
    }

    public synchronized void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> res = new HashSet<DiscoverInfo.Identity>(this.identities);
        res.add(defaultIdentity);
        return Collections.unmodifiableSet(res);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection connection) {
        ServiceDiscoveryManager sdm = instances.get(connection);
        if (sdm == null) {
            sdm = new ServiceDiscoveryManager(connection);
            instances.put(connection, sdm);
        }
        return sdm;
    }

    public synchronized void addDiscoverInfoTo(DiscoverInfo response) {
        response.addIdentities(this.getIdentities());
        for (String feature : this.getFeatures()) {
            response.addFeature(feature);
        }
        response.addExtension(this.extendedInfo);
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    public synchronized List<String> getFeatures() {
        return new ArrayList<String>(this.features);
    }

    public synchronized void addFeature(String feature) {
        this.features.add(feature);
        this.renewEntityCapsVersion();
    }

    public synchronized void removeFeature(String feature) {
        this.features.remove(feature);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean includesFeature(String feature) {
        return this.features.contains(feature);
    }

    public synchronized void setExtendedInfo(DataForm info) {
        this.extendedInfo = info;
        this.renewEntityCapsVersion();
    }

    public DataForm getExtendedInfo() {
        return this.extendedInfo;
    }

    public List<ExtensionElement> getExtendedInfoAsList() {
        ArrayList<DataForm> res = null;
        if (this.extendedInfo != null) {
            res = new ArrayList<DataForm>(1);
            res.add(this.extendedInfo);
        }
        return res;
    }

    public synchronized void removeExtendedInfo() {
        this.extendedInfo = null;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo discoverInfo(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (entityID == null) {
            return this.discoverInfo(null, null);
        }
        DiscoverInfo info = EntityCapsManager.getDiscoverInfoByUser(entityID);
        if (info != null) {
            return info;
        }
        EntityCapsManager.NodeVerHash nvh = EntityCapsManager.getNodeVerHashByJid(entityID);
        info = this.discoverInfo(entityID, nvh != null ? nvh.getNodeVer() : null);
        if (nvh != null && EntityCapsManager.verifyDiscoverInfoVersion(nvh.getVer(), nvh.getHash(), info)) {
            EntityCapsManager.addDiscoverInfoByNode(nvh.getNodeVer(), info);
        }
        return info;
    }

    public DiscoverInfo discoverInfo(Jid entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo disco = new DiscoverInfo();
        disco.setType(IQ.Type.get);
        disco.setTo(entityID);
        disco.setNode(node);
        Stanza result = this.connection().createStanzaCollectorAndSend((IQ)disco).nextResultOrThrow();
        return (DiscoverInfo)result;
    }

    public DiscoverItems discoverItems(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(Jid entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.get);
        disco.setTo(entityID);
        disco.setNode(node);
        Stanza result = this.connection().createStanzaCollectorAndSend((IQ)disco).nextResultOrThrow();
        return (DiscoverItems)result;
    }

    public boolean canPublishItems(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo info = this.discoverInfo(entityID);
        return ServiceDiscoveryManager.canPublishItems(info);
    }

    public static boolean canPublishItems(DiscoverInfo info) {
        return info.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(Jid entityID, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.publishItems(entityID, null, discoverItems);
    }

    public void publishItems(Jid entityID, String node, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        discoverItems.setType(IQ.Type.set);
        discoverItems.setTo(entityID);
        discoverItems.setNode(node);
        this.connection().createStanzaCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
    }

    public boolean serverSupportsFeature(CharSequence feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serverSupportsFeatures(feature);
    }

    public boolean serverSupportsFeatures(CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serverSupportsFeatures(Arrays.asList(features));
    }

    public boolean serverSupportsFeatures(Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures((Jid)this.connection().getXMPPServiceDomain(), features);
    }

    public boolean supportsFeature(Jid jid, CharSequence feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures(jid, feature);
    }

    public boolean supportsFeatures(Jid jid, CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures(jid, Arrays.asList(features));
    }

    public boolean supportsFeatures(Jid jid, Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo result = this.discoverInfo(jid);
        for (CharSequence charSequence : features) {
            if (result.containsFeature(charSequence)) continue;
            return false;
        }
        return true;
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(String feature, boolean stopOnFirst, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items;
        DiscoverInfo info;
        LinkedList<DiscoverInfo> serviceDiscoInfo = null;
        DomainBareJid serviceName = this.connection().getXMPPServiceDomain();
        if (useCache && (serviceDiscoInfo = (List)this.services.lookup((Object)feature)) != null) {
            return serviceDiscoInfo;
        }
        serviceDiscoInfo = new LinkedList();
        try {
            info = this.discoverInfo((Jid)serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could not discover information about service", e);
            return serviceDiscoInfo;
        }
        if (info.containsFeature(feature)) {
            serviceDiscoInfo.add(info);
            if (stopOnFirst) {
                if (useCache) {
                    this.services.put((Object)feature, serviceDiscoInfo);
                }
                return serviceDiscoInfo;
            }
        }
        try {
            items = this.discoverItems((Jid)serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could not discover items about service", e);
            return serviceDiscoInfo;
        }
        for (DiscoverItems.Item item : items.getItems()) {
            try {
                info = this.discoverInfo(item.getEntityID());
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Exception while discovering info for feature " + feature + " of " + item.getEntityID() + " node: " + item.getNode(), e);
                continue;
            }
            if (!info.containsFeature(feature)) continue;
            serviceDiscoInfo.add(info);
            if (!stopOnFirst) continue;
            break;
        }
        if (useCache) {
            this.services.put((Object)feature, serviceDiscoInfo);
        }
        return serviceDiscoInfo;
    }

    public List<DomainBareJid> findServices(String feature, boolean stopOnFirst, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        List<DiscoverInfo> services = this.findServicesDiscoverInfo(feature, stopOnFirst, useCache);
        ArrayList<DomainBareJid> res = new ArrayList<DomainBareJid>(services.size());
        for (DiscoverInfo info : services) {
            res.add(info.getFrom().asDomainBareJid());
        }
        return res;
    }

    public DomainBareJid findService(String feature, boolean useCache, String category, String type) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        List<DiscoverInfo> services = this.findServicesDiscoverInfo(feature, true, useCache);
        if (services.isEmpty()) {
            return null;
        }
        DiscoverInfo info = services.get(0);
        if (category != null && type != null) {
            if (!info.hasIdentity(category, type)) {
                return null;
            }
        } else if (category != null || type != null) {
            throw new IllegalArgumentException("Must specify either both, category and type, or none");
        }
        return info.getFrom().asDomainBareJid();
    }

    public DomainBareJid findService(String feature, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.findService(feature, useCache, null, null);
    }

    public void setEntityCapsManager(EntityCapsManager manager) {
        this.capsManager = manager;
    }

    private void renewEntityCapsVersion() {
        if (this.capsManager != null && this.capsManager.entityCapsEnabled()) {
            this.capsManager.updateLocalEntityCaps();
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection);
            }
        });
    }
}

