/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.edns;

import de.measite.minidns.EDNS;
import de.measite.minidns.edns.NSID;
import de.measite.minidns.edns.UnknownEDNSOption;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class EDNSOption {
    public final int optionCode;
    public final int optionLength;
    protected final byte[] optionData;
    private String toStringCache;
    private String terminalOutputCache;

    protected EDNSOption(int optionCode, byte[] optionData) {
        this.optionCode = optionCode;
        this.optionLength = optionData.length;
        this.optionData = optionData;
    }

    protected EDNSOption(byte[] optionData) {
        this.optionCode = this.getOptionCode().asInt;
        this.optionLength = optionData.length;
        this.optionData = optionData;
    }

    public final void writeToDos(DataOutputStream dos) throws IOException {
        dos.writeShort(this.optionCode);
        dos.writeShort(this.optionLength);
        dos.write(this.optionData);
    }

    public abstract EDNS.OptionCode getOptionCode();

    public final String toString() {
        if (this.toStringCache == null) {
            this.toStringCache = this.toStringInternal().toString();
        }
        return this.toStringCache;
    }

    protected abstract CharSequence toStringInternal();

    public final String asTerminalOutput() {
        if (this.terminalOutputCache == null) {
            this.terminalOutputCache = this.asTerminalOutputInternal().toString();
        }
        return this.terminalOutputCache;
    }

    protected abstract CharSequence asTerminalOutputInternal();

    public static EDNSOption parse(int intOptionCode, byte[] optionData) {
        EDNSOption res;
        EDNS.OptionCode optionCode = EDNS.OptionCode.from(intOptionCode);
        switch (optionCode) {
            case NSID: {
                res = new NSID(optionData);
                break;
            }
            default: {
                res = new UnknownEDNSOption(intOptionCode, optionData);
            }
        }
        return res;
    }
}

