/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dnsserverlookup;

import de.measite.minidns.dnsserverlookup.AbstractDNSServerLookupMechanism;
import de.measite.minidns.dnsserverlookup.DNSServerLookupMechanism;
import de.measite.minidns.util.PlatformDetection;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Level;

public class AndroidUsingReflection
extends AbstractDNSServerLookupMechanism {
    public static final DNSServerLookupMechanism INSTANCE = new AndroidUsingReflection();
    public static final int PRIORITY = 1000;

    protected AndroidUsingReflection() {
        super(AndroidUsingReflection.class.getSimpleName(), 1000);
    }

    @Override
    public String[] getDnsServerAddresses() {
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            ArrayList<String> servers = new ArrayList<String>(5);
            for (String propKey : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
                InetAddress ip;
                String value = (String)method.invoke(null, propKey);
                if (value == null || value.length() == 0 || servers.contains(value) || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0 || servers.contains(value)) continue;
                servers.add(value);
            }
            if (servers.size() > 0) {
                return servers.toArray(new String[servers.size()]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception in findDNSByReflection", e);
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return PlatformDetection.isAndroid();
    }
}

