/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.TopLevelStreamElement;

public class SynchronizationPoint<E extends Exception> {
    private final AbstractXMPPConnection connection;
    private final Lock connectionLock;
    private final Condition condition;
    private final String waitFor;
    private State state;
    private E failureException;

    public SynchronizationPoint(AbstractXMPPConnection connection, String waitFor) {
        this.connection = connection;
        this.connectionLock = connection.getConnectionLock();
        this.condition = connection.getConnectionLock().newCondition();
        this.waitFor = waitFor;
        this.init();
    }

    public void init() {
        this.connectionLock.lock();
        this.state = State.Initial;
        this.failureException = null;
        this.connectionLock.unlock();
    }

    public E sendAndWaitForResponse(TopLevelStreamElement request) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        assert (this.state == State.Initial);
        this.connectionLock.lock();
        try {
            if (request != null) {
                if (request instanceof Stanza) {
                    this.connection.sendStanza((Stanza)request);
                } else if (request instanceof Nonza) {
                    this.connection.sendNonza((Nonza)request);
                } else {
                    throw new IllegalStateException("Unsupported element type");
                }
                this.state = State.RequestSent;
            }
            this.waitForConditionOrTimeout();
        }
        finally {
            this.connectionLock.unlock();
        }
        return this.checkForResponse();
    }

    public void sendAndWaitForResponseOrThrow(Nonza request) throws E, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.sendAndWaitForResponse(request);
        switch (this.state) {
            case Failure: {
                if (this.failureException == null) break;
                throw this.failureException;
            }
        }
    }

    public void checkIfSuccessOrWaitOrThrow() throws SmackException.NoResponseException, E, InterruptedException {
        this.checkIfSuccessOrWait();
        if (this.state == State.Failure) {
            throw this.failureException;
        }
    }

    public E checkIfSuccessOrWait() throws SmackException.NoResponseException, InterruptedException {
        this.connectionLock.lock();
        try {
            switch (this.state) {
                case Success: {
                    E e = null;
                    return e;
                }
                case Failure: {
                    E e = this.failureException;
                    return e;
                }
            }
            this.waitForConditionOrTimeout();
        }
        finally {
            this.connectionLock.unlock();
        }
        return this.checkForResponse();
    }

    public void reportSuccess() {
        this.connectionLock.lock();
        try {
            this.state = State.Success;
            this.condition.signalAll();
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    @Deprecated
    public void reportFailure() {
        this.reportFailure(null);
    }

    public void reportFailure(E failureException) {
        assert (failureException != null);
        this.connectionLock.lock();
        try {
            this.state = State.Failure;
            this.failureException = failureException;
            this.condition.signalAll();
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public boolean wasSuccessful() {
        this.connectionLock.lock();
        try {
            boolean bl = this.state == State.Success;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    public boolean requestSent() {
        this.connectionLock.lock();
        try {
            boolean bl = this.state == State.RequestSent;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    private void waitForConditionOrTimeout() throws InterruptedException {
        long remainingWait = TimeUnit.MILLISECONDS.toNanos(this.connection.getReplyTimeout());
        while (this.state == State.RequestSent || this.state == State.Initial) {
            if (remainingWait <= 0L) {
                this.state = State.NoResponse;
                break;
            }
            remainingWait = this.condition.awaitNanos(remainingWait);
        }
    }

    private E checkForResponse() throws SmackException.NoResponseException {
        switch (this.state) {
            case Initial: 
            case NoResponse: 
            case RequestSent: {
                throw SmackException.NoResponseException.newWith((XMPPConnection)this.connection, this.waitFor);
            }
            case Success: {
                return null;
            }
            case Failure: {
                return this.failureException;
            }
        }
        throw new AssertionError((Object)("Unknown state " + (Object)((Object)this.state)));
    }

    private static enum State {
        Initial,
        RequestSent,
        NoResponse,
        Success,
        Failure;

    }
}

