/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.hla;

import de.measite.minidns.AbstractDNSClient;
import de.measite.minidns.DNSCache;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.DNSName;
import de.measite.minidns.MiniDNSException;
import de.measite.minidns.Question;
import de.measite.minidns.Record;
import de.measite.minidns.cache.LRUCache;
import de.measite.minidns.cache.MiniDnsCacheFactory;
import de.measite.minidns.dnssec.DNSSECClient;
import de.measite.minidns.dnssec.DNSSECMessage;
import de.measite.minidns.hla.ResolverApi;
import de.measite.minidns.hla.ResolverResult;
import de.measite.minidns.iterative.ReliableDNSClient;
import de.measite.minidns.record.Data;
import java.io.IOException;
import java.util.Set;

public class DnssecResolverApi
extends ResolverApi {
    public static final DnssecResolverApi INSTANCE = new DnssecResolverApi();
    private final DNSSECClient dnssecClient;
    private final DNSSECClient iterativeOnlyDnssecClient;
    private final DNSSECClient recursiveOnlyDnssecClient;

    public DnssecResolverApi() {
        this(new MiniDnsCacheFactory(){

            public DNSCache newCache() {
                return new LRUCache(1024);
            }
        });
    }

    public DnssecResolverApi(MiniDnsCacheFactory cacheFactory) {
        this(new DNSSECClient(cacheFactory.newCache()), cacheFactory);
    }

    private DnssecResolverApi(DNSSECClient dnssecClient, MiniDnsCacheFactory cacheFactory) {
        super((AbstractDNSClient)dnssecClient);
        this.dnssecClient = dnssecClient;
        this.iterativeOnlyDnssecClient = new DNSSECClient(cacheFactory.newCache());
        this.iterativeOnlyDnssecClient.setMode(ReliableDNSClient.Mode.iterativeOnly);
        this.recursiveOnlyDnssecClient = new DNSSECClient(cacheFactory.newCache());
        this.recursiveOnlyDnssecClient.setMode(ReliableDNSClient.Mode.recursiveOnly);
    }

    @Override
    public <D extends Data> ResolverResult<D> resolve(Question question) throws IOException {
        DNSSECMessage dnssecMessage = this.dnssecClient.queryDnssec(question);
        return DnssecResolverApi.toResolverResult(question, dnssecMessage);
    }

    public <D extends Data> ResolverResult<D> resolveDnssecReliable(String name, Class<D> type) throws IOException {
        return this.resolveDnssecReliable(DNSName.from((String)name), type);
    }

    public <D extends Data> ResolverResult<D> resolveDnssecReliable(DNSName name, Class<D> type) throws IOException {
        Record.TYPE t = Record.TYPE.getType(type);
        Question q = new Question(name, t);
        return this.resolveDnssecReliable(q);
    }

    public <D extends Data> ResolverResult<D> resolveDnssecReliable(Question question) throws IOException {
        DNSSECMessage dnssecMessage = this.recursiveOnlyDnssecClient.queryDnssec(question);
        if (dnssecMessage == null || !dnssecMessage.authenticData) {
            dnssecMessage = this.iterativeOnlyDnssecClient.queryDnssec(question);
        }
        return DnssecResolverApi.toResolverResult(question, dnssecMessage);
    }

    public DNSSECClient getDnssecClient() {
        return this.dnssecClient;
    }

    private static <D extends Data> ResolverResult<D> toResolverResult(Question question, DNSSECMessage dnssecMessage) throws MiniDNSException.NullResultException {
        Set unverifiedReasons = dnssecMessage.getUnverifiedReasons();
        return new ResolverResult(question, (DNSMessage)dnssecMessage, unverifiedReasons);
    }
}

