/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.DNSName;
import de.measite.minidns.Record;
import de.measite.minidns.record.Data;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SRV
extends Data {
    public final int priority;
    public final int weight;
    public final int port;
    public final DNSName name;

    public static SRV parse(DataInputStream dis, byte[] data) throws IOException {
        int priority = dis.readUnsignedShort();
        int weight = dis.readUnsignedShort();
        int port = dis.readUnsignedShort();
        DNSName name = DNSName.parse(dis, data);
        return new SRV(priority, weight, port, name);
    }

    public SRV(int priority, int weight, int port, String name) {
        this(priority, weight, port, DNSName.from(name));
    }

    public SRV(int priority, int weight, int port, DNSName name) {
        this.priority = priority;
        this.weight = weight;
        this.port = port;
        this.name = name;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeShort(this.priority);
        dos.writeShort(this.weight);
        dos.writeShort(this.port);
        this.name.writeToStream(dos);
    }

    public String toString() {
        return this.priority + " " + this.weight + " " + this.port + " " + this.name + ".";
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.SRV;
    }
}

