/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.Record;
import de.measite.minidns.edns.EDNSOption;
import de.measite.minidns.record.Data;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OPT
extends Data {
    public final List<EDNSOption> variablePart;

    public OPT() {
        this(Collections.emptyList());
    }

    public OPT(List<EDNSOption> variablePart) {
        this.variablePart = Collections.unmodifiableList(variablePart);
    }

    public static OPT parse(DataInputStream dis, int payloadLength) throws IOException {
        List<EDNSOption> variablePart;
        if (payloadLength == 0) {
            variablePart = Collections.emptyList();
        } else {
            int payloadLeft = payloadLength;
            variablePart = new ArrayList<EDNSOption>(4);
            while (payloadLeft > 0) {
                int optionCode = dis.readUnsignedShort();
                int optionLength = dis.readUnsignedShort();
                byte[] optionData = new byte[optionLength];
                dis.read(optionData);
                EDNSOption ednsOption = EDNSOption.parse(optionCode, optionData);
                variablePart.add(ednsOption);
                assert ((payloadLeft -= 4 + optionLength) >= 0);
            }
        }
        return new OPT(variablePart);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.OPT;
    }

    @Override
    protected void serialize(DataOutputStream dos) throws IOException {
        for (EDNSOption endsOption : this.variablePart) {
            endsOption.writeToDos(dos);
        }
    }
}

