/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.record;

import de.measite.minidns.DNSSECConstants;
import de.measite.minidns.Record;
import de.measite.minidns.record.Data;
import de.measite.minidns.util.Base64;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class DNSKEY
extends Data {
    public static final short FLAG_SECURE_ENTRY_POINT = 1;
    public static final short FLAG_REVOKE = 128;
    public static final short FLAG_ZONE = 256;
    public static final byte PROTOCOL_RFC4034 = 3;
    public final short flags;
    public final byte protocol;
    public final DNSSECConstants.SignatureAlgorithm algorithm;
    public final byte algorithmByte;
    private final byte[] key;
    private Integer keyTag;
    private String keyBase64Cache;

    public static DNSKEY parse(DataInputStream dis, int length) throws IOException {
        short flags = dis.readShort();
        byte protocol = dis.readByte();
        byte algorithm = dis.readByte();
        byte[] key = new byte[length - 4];
        dis.readFully(key);
        return new DNSKEY(flags, protocol, algorithm, key);
    }

    private DNSKEY(short flags, byte protocol, DNSSECConstants.SignatureAlgorithm algorithm, byte algorithmByte, byte[] key) {
        this.flags = flags;
        this.protocol = protocol;
        assert (algorithmByte == (algorithm != null ? algorithm.number : algorithmByte));
        this.algorithmByte = algorithmByte;
        this.algorithm = algorithm != null ? algorithm : DNSSECConstants.SignatureAlgorithm.forByte(algorithmByte);
        this.key = key;
    }

    public DNSKEY(short flags, byte protocol, byte algorithm, byte[] key) {
        this(flags, protocol, DNSSECConstants.SignatureAlgorithm.forByte(algorithm), key);
    }

    public DNSKEY(short flags, byte protocol, DNSSECConstants.SignatureAlgorithm algorithm, byte[] key) {
        this(flags, protocol, algorithm, algorithm.number, key);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.DNSKEY;
    }

    public int getKeyTag() {
        if (this.keyTag == null) {
            byte[] recordBytes = this.toByteArray();
            long ac = 0L;
            for (int i = 0; i < recordBytes.length; ++i) {
                ac += (i & 1) > 0 ? (long)recordBytes[i] & 0xFFL : ((long)recordBytes[i] & 0xFFL) << 8;
            }
            ac += ac >> 16 & 0xFFFFL;
            this.keyTag = (int)(ac & 0xFFFFL);
        }
        return this.keyTag;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeShort(this.flags);
        dos.writeByte(this.protocol);
        dos.writeByte(this.algorithm.number);
        dos.write(this.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.flags).append(' ').append(this.protocol).append(' ').append((Object)this.algorithm).append(' ').append(Base64.encodeToString(this.key));
        return sb.toString();
    }

    public int getKeyLength() {
        return this.key.length;
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public String getKeyBase64() {
        if (this.keyBase64Cache == null) {
            this.keyBase64Cache = Base64.encodeToString(this.key);
        }
        return this.keyBase64Cache;
    }

    public boolean keyEquals(byte[] otherKey) {
        return Arrays.equals(this.key, otherKey);
    }

    public boolean isSecureEntryPoint() {
        return (this.flags & 1) == 1;
    }
}

