use diesel_derives::Queryable;

#[derive(serde::Serialize, serde::Deserialize, Queryable, Clone, Debug, Default, PartialEq, Eq)]
#[diesel(table_name = datas)]
pub struct CardDatas {
    pub id: i64,
    pub ot: i32,
    pub alias: i32,
    pub setcode: i32,
    pub type_: i32,
    pub atk: i32,
    pub def: i32,
    pub level: i32,
    pub race: i32,
    pub attribute: i32,
    pub category: i32,
}

// TODO: 这里字段应该命名得更清晰一点
#[derive(serde::Serialize, serde::Deserialize, Queryable, Clone, Debug, Default, PartialEq, Eq)]
#[diesel(table_name = texts)]
pub struct CardTexts {
    pub id: i64,
    pub name: String,
    pub desc: Option<String>,
    pub str1: Option<String>,
    pub str2: Option<String>,
    pub str3: Option<String>,
    pub str4: Option<String>,
    pub str5: Option<String>,
    pub str6: Option<String>,
    pub str7: Option<String>,
    pub str8: Option<String>,
    pub str9: Option<String>,
    pub str10: Option<String>,
    pub str11: Option<String>,
    pub str12: Option<String>,
    pub str13: Option<String>,
    pub str14: Option<String>,
    pub str15: Option<String>,
    pub str16: Option<String>,
}

impl CardTexts {
    pub fn get_str_by_offset(&self, offset: usize) -> Option<String> {
        match offset {
            1 => self.str1.to_owned(),
            2 => self.str2.to_owned(),
            3 => self.str3.to_owned(),
            4 => self.str4.to_owned(),
            5 => self.str5.to_owned(),
            6 => self.str6.to_owned(),
            7 => self.str7.to_owned(),
            8 => self.str8.to_owned(),
            9 => self.str9.to_owned(),
            10 => self.str10.to_owned(),
            11 => self.str11.to_owned(),
            12 => self.str12.to_owned(),
            13 => self.str13.to_owned(),
            14 => self.str14.to_owned(),
            15 => self.str15.to_owned(),
            16 => self.str16.to_owned(),
            _ => None,
        }
    }
}
