use std::{net::SocketAddr, str::FromStr};
use warp::Filter;

mod infra;
mod service;

// TODO: Configurable
const DECK_ADDR: &str = "127.0.0.1:3030";
const CARDS_ADDR: &str = "127.0.0.1:3033";

#[tokio::main]
async fn main() -> anyhow::Result<()> {
    pretty_env_logger::try_init()?;

    // TODO: use CORS correctly
    let cors = warp::cors()
        .allow_any_origin()
        .allow_credentials(true)
        .allow_header("content-type")
        .allow_method("GET");

    let deck = warp::path!("deck" / String)
        .map(service::deck_service)
        .with(cors.clone());
    warp::serve(deck)
        .run(SocketAddr::from_str(DECK_ADDR)?)
        .await;

    // TODO: cards服务暂时仅支持单卡查询
    let cards = warp::path!("cards" / String)
        .map(service::cards_service)
        .with(cors);
    warp::serve(cards)
        .run(SocketAddr::from_str(CARDS_ADDR)?)
        .await;

    Ok(())
}
